/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests.config.serialization;

import com.google.common.reflect.TypeToken;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import online.pixelbuilt.pbquests.reward.RewardType;
import online.pixelbuilt.pbquests.task.TaskType;
import online.pixelbuilt.pbquests.utils.BaseType;

public class ValueWrapper<T> {
    private T value;
    private BaseType type;

    public ValueWrapper(T obj, BaseType type) {
        this.value = obj;
        this.type = type;
    }

    public T getValue() {
        return this.value;
    }

    public BaseType getType() {
        return this.type;
    }

    public static class ValueWrapperTypeSerializer
    implements TypeSerializer<ValueWrapper> {
        public ValueWrapper deserialize(TypeToken<?> typeToken, ConfigurationNode configurationNode) throws ObjectMappingException {
            try {
                BaseType type = null;
                try {
                    type = (BaseType)configurationNode.getNode(new Object[]{"type"}).getValue(TypeToken.of(TaskType.class));
                }
                catch (ObjectMappingException e1) {
                    type = (BaseType)configurationNode.getNode(new Object[]{"type"}).getValue(TypeToken.of(RewardType.class));
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                Class clazz = type.getValueClass();
                return new ValueWrapper<Object>(configurationNode.getNode(new Object[]{"value"}).getValue(TypeToken.of(clazz), clazz.newInstance()), type);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public void serialize(TypeToken<?> typeToken, ValueWrapper valueWrapper, ConfigurationNode configurationNode) throws ObjectMappingException {
            try {
                BaseType type = valueWrapper.getType();
                TypeToken token1 = TypeToken.of(type.getClass());
                configurationNode.getNode(new Object[]{"type"}).setValue(token1, (Object)type);
                Object value = valueWrapper.getValue();
                TypeToken token = TypeToken.of(value.getClass());
                configurationNode.getNode(new Object[]{"value"}).setValue(token, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

