/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests.quest.executor.impl;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import online.pixelbuilt.pbquests.PixelBuiltQuests;
import online.pixelbuilt.pbquests.config.ConfigManager;
import online.pixelbuilt.pbquests.config.serialization.ValueWrapper;
import online.pixelbuilt.pbquests.quest.Quest;
import online.pixelbuilt.pbquests.quest.QuestLine;
import online.pixelbuilt.pbquests.quest.executor.QuestExecutor;
import online.pixelbuilt.pbquests.reward.BaseReward;
import online.pixelbuilt.pbquests.task.BaseTask;
import online.pixelbuilt.pbquests.utils.Util;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;

public class BaseQuestExecutor
implements QuestExecutor {
    private Quest quest;
    private QuestLine questLine;
    private int questId;
    private UUID player;

    public BaseQuestExecutor() {
    }

    private BaseQuestExecutor(Quest quest, QuestLine questLine, int questId, UUID player) {
        this.quest = quest;
        this.questLine = questLine;
        this.questId = questId;
        this.player = player;
    }

    @Override
    public void execute(Quest quest, QuestLine questLine, int questId, Player player) {
        new BaseQuestExecutor(quest, questLine, questId, player.getUniqueId()).run();
    }

    public void run() {
        BaseTask task;
        Player player = this.getPlayer();
        for (ValueWrapper<? extends BaseTask> v : this.quest.tasks) {
            task = v.getValue();
            if (task.check(player, this.quest, this.questLine, this.questId)) continue;
            return;
        }
        for (ValueWrapper<? extends BaseTask> v : this.quest.tasks) {
            task = v.getValue();
            task.complete(player, this.quest, this.questLine, this.questId);
        }
        PixelBuiltQuests.runningQuests.add(player.getUniqueId());
        if (this.quest.denyMovement && !PixelBuiltQuests.playersBusy.contains(player.getUniqueId())) {
            PixelBuiltQuests.playersBusy.add(player.getUniqueId());
        }
        if (this.quest.timeBetweenMessages == 0) {
            for (String s : this.quest.messages) {
                player.sendMessage(Util.toText(s.replace("%player%", player.getName())));
            }
            this.continueTask();
        } else {
            int count = 0;
            if (this.quest.messages.isEmpty()) {
                this.continueTask();
            }
            for (String msg : this.quest.messages) {
                int currentCount = count += this.quest.timeBetweenMessages;
                Task.builder().delay((long)count, TimeUnit.SECONDS).execute(() -> {
                    Player pl = this.getPlayer();
                    if (pl != null) {
                        pl.sendMessage(Util.toText(msg.replace("%player%", pl.getName())));
                    }
                    if (currentCount == this.quest.messages.size()) {
                        Task.builder().delay((long)this.quest.timeBetweenMessages, TimeUnit.SECONDS).execute(this::continueTask).submit((Object)PixelBuiltQuests.instance);
                    }
                }).submit((Object)PixelBuiltQuests.instance);
            }
        }
    }

    public void continueTask() {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        if (this.quest.denyMovement) {
            PixelBuiltQuests.playersBusy.remove(player.getUniqueId());
        }
        PixelBuiltQuests.runningQuests.remove(player.getUniqueId());
        for (ValueWrapper<? extends BaseReward> v : this.quest.rewards) {
            BaseReward reward = v.getValue();
            reward.execute(player, this.quest, this.questLine, this.questId);
        }
        String finish = ConfigManager.getConfig().messages.finish;
        if (!finish.isEmpty() && !this.quest.displayName.isEmpty()) {
            player.sendMessage(Util.toText(finish.replace("%quest%", this.quest.displayName)));
        }
    }

    private Player getPlayer() {
        return Sponge.getServer().getPlayer(this.player).orElse(null);
    }
}

