/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests.storage;

import java.util.List;
import java.util.UUID;
import online.pixelbuilt.pbquests.PixelBuiltQuests;
import online.pixelbuilt.pbquests.config.Config;
import online.pixelbuilt.pbquests.config.Trigger;
import online.pixelbuilt.pbquests.config.TriggersCategory;
import online.pixelbuilt.pbquests.quest.Quest;
import online.pixelbuilt.pbquests.quest.QuestLine;
import online.pixelbuilt.pbquests.storage.DatabaseConfig;
import online.pixelbuilt.pbquests.storage.StorageModule;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FileStorage
implements StorageModule {
    private Config<DatabaseConfig> dbConfig;
    private Config<TriggersCategory> triggersConfig;

    public FileStorage() {
        this.dbConfig = new Config<DatabaseConfig>(DatabaseConfig.class, "Database.conf", PixelBuiltQuests.getInstance().configDir);
        this.triggersConfig = new Config<TriggersCategory>(TriggersCategory.class, "Triggers.conf", PixelBuiltQuests.getInstance().configDir);
    }

    @Override
    public void init(PixelBuiltQuests instance) {
    }

    @Override
    public int getProgress(UUID player, QuestLine line) {
        return this.dbConfig.get().getProgress(player, line.getName());
    }

    @Override
    public void setProgress(UUID player, QuestLine line, int progress) {
        this.dbConfig.get().setProgress(player, line.getName(), progress);
        this.dbConfig.save();
    }

    @Override
    public Tuple<Quest, QuestLine> getQuest(Entity npc) {
        return this.dbConfig.get().getQuestFromNPC(npc);
    }

    @Override
    public void addNPC(Entity npc, QuestLine line, int questId) {
        this.dbConfig.get().addNPC(npc, line.getName(), questId);
        this.dbConfig.save();
    }

    @Override
    public void removeNPC(Entity npc) {
        this.dbConfig.get().removeNPC(npc);
        this.dbConfig.save();
    }

    @Override
    public boolean hasRan(UUID player, QuestLine line, int questId) {
        return this.dbConfig.get().hasRan(player, line.getName(), questId);
    }

    @Override
    public void run(UUID player, QuestLine line, int questId) {
        this.dbConfig.get().run(player, line.getName(), questId);
        this.dbConfig.save();
    }

    @Override
    public Trigger getTriggerAt(Location<World> location) {
        return this.triggersConfig.get().at(location);
    }

    @Override
    public void addTrigger(Trigger trigger) {
        this.triggersConfig.get().triggers.add(trigger);
        this.triggersConfig.save();
    }

    @Override
    public void removeTrigger(Trigger trigger) {
        this.triggersConfig.get().triggers.remove(trigger);
        this.triggersConfig.save();
    }

    @Override
    public List<Trigger> getTriggers() {
        return this.triggersConfig.get().triggers;
    }

    @Override
    public List<String> getQuestsRan(UUID player) {
        return this.dbConfig.get().entries.getOrDefault((Object)player, (DatabaseConfig.PlayerEntry)new DatabaseConfig.PlayerEntry()).questsRan;
    }

    @Override
    public void resetQuest(UUID player, QuestLine line, int questId) {
        this.getQuestsRan(player).remove(line.getName() + "," + questId);
        this.dbConfig.save();
    }

    @Override
    public void shutdown() {
        this.dbConfig.save();
        this.triggersConfig.save();
    }
}

