/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import online.pixelbuilt.pbquests.task.TaskType;
import online.pixelbuilt.pbquests.task.TaskTypes;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.RegistrationPhase;
import org.spongepowered.api.registry.util.DelayedRegistration;

public class TaskRegistryModule
implements AdditionalCatalogRegistryModule<TaskType> {
    private Map<String, TaskType> tasks = Maps.newHashMap();

    public void registerAdditionalCatalog(TaskType extraCatalog) {
        this.tasks.put(extraCatalog.getId(), extraCatalog);
    }

    public Optional<TaskType> getById(String id) {
        String key = id.toLowerCase();
        if (!key.contains(":")) {
            key = "pbq:" + key;
        }
        return Optional.ofNullable(this.tasks.get(key));
    }

    public Collection<TaskType> getAll() {
        return ImmutableList.copyOf(this.tasks.values());
    }

    @DelayedRegistration(value=RegistrationPhase.INIT)
    public void registerDefaults() {
        this.tasks.putAll(TaskTypes.defaults().stream().collect(Collectors.toMap(CatalogType::getId, t -> t)));
    }
}

