/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests.task.impl;

import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import online.pixelbuilt.pbquests.config.ConfigManager;
import online.pixelbuilt.pbquests.quest.Quest;
import online.pixelbuilt.pbquests.quest.QuestLine;
import online.pixelbuilt.pbquests.task.BaseTask;
import online.pixelbuilt.pbquests.utils.Util;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;

@ConfigSerializable
public class ItemTask
implements BaseTask<ItemTask> {
    @Setting
    public ItemType item = ItemTypes.STONE;
    @Setting
    public int amount = 1;

    @Override
    public boolean check(Player player, Quest quest, QuestLine line, int questId) {
        Inventory inv = player.getInventory().query(new QueryOperation[]{QueryOperationTypes.ITEM_TYPE.of((Object)this.item)});
        if (inv.totalItems() < this.amount) {
            player.sendMessage(Util.toText(ConfigManager.getConfig().messages.noItem.replace("%item%", this.item.getName()).replace("%amount%", "" + this.amount)));
            return false;
        }
        return true;
    }

    @Override
    public void complete(Player player, Quest quest, QuestLine line, int questId) {
        player.getInventory().query(new QueryOperation[]{QueryOperationTypes.ITEM_TYPE.of((Object)this.item)}).poll(this.amount);
    }
}

