/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests.task.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import online.pixelbuilt.pbquests.quest.Quest;
import online.pixelbuilt.pbquests.quest.QuestLine;
import online.pixelbuilt.pbquests.task.BaseTask;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;

@ConfigSerializable
public class KillTask
implements BaseTask<KillTask> {
    public static Multimap<UUID, EntityType> killed = ArrayListMultimap.create();
    @Setting(comment="checking mode. 1 = killed at least one specific mob, 2 = killed at least X specific mobs, 3 = killed at least one mob, 4 = killed at least X mobs")
    public int checkMode = 1;
    @Setting
    public int mobCount = 5;
    @Setting
    public EntityType mob = EntityTypes.ZOMBIE;

    @Override
    public boolean check(Player player, Quest quest, QuestLine line, int questId) {
        if (this.checkMode == 1) {
            return killed.get((Object)player.getUniqueId()).contains(this.mob);
        }
        if (this.checkMode == 2) {
            return killed.get((Object)player.getUniqueId()).stream().filter(this.mob::equals).count() >= (long)this.mobCount;
        }
        if (this.checkMode == 3) {
            return !killed.get((Object)player.getUniqueId()).isEmpty();
        }
        if (this.checkMode == 4) {
            return killed.get((Object)player.getUniqueId()).size() >= this.mobCount;
        }
        return false;
    }

    @Override
    public void complete(Player player, Quest quest, QuestLine line, int questId) {
    }
}

