/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests.task.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.UUID;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import online.pixelbuilt.pbquests.quest.Quest;
import online.pixelbuilt.pbquests.quest.QuestLine;
import online.pixelbuilt.pbquests.task.BaseTask;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

@ConfigSerializable
public class VisitTask
implements BaseTask<VisitTask> {
    @Setting
    public String visitLocation = "0,0,0,world";
    @Setting
    public int visitRadius = 5;
    public static Multimap<VisitTask, UUID> locations = ArrayListMultimap.create();

    @Override
    public boolean check(Player player, Quest quest, QuestLine line, int questId) {
        Location<World> loc = this.getLocation();
        if (loc == null) {
            return true;
        }
        if (!locations.containsKey((Object)this)) {
            locations.put((Object)this, (Object)UUID.randomUUID());
        }
        for (Map.Entry e : locations.entries()) {
            if (!((UUID)e.getValue()).equals(player.getUniqueId()) || !((World)((VisitTask)e.getKey()).getLocation().getExtent()).equals(loc.getExtent()) || ((VisitTask)e.getKey()).getLocation().getBlockPosition().distanceSquared(loc.getBlockPosition()) > this.visitRadius) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof VisitTask;
    }

    public Location<World> getLocation() {
        String[] string = this.visitLocation.split(",");
        World world = Sponge.getServer().getWorld(string[3]).orElse(null);
        if (world == null) {
            return null;
        }
        return new Location((Extent)world, Integer.parseInt(string[0]), Integer.parseInt(string[1]), Integer.parseInt(string[2]));
    }
}

