/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests.utils;

import com.google.common.collect.Lists;
import io.github.eufranio.pbqmessages.PBQMessages;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import online.pixelbuilt.pbquests.PixelBuiltQuests;
import online.pixelbuilt.pbquests.config.ConfigManager;
import online.pixelbuilt.pbquests.config.Trigger;
import online.pixelbuilt.pbquests.quest.Quest;
import online.pixelbuilt.pbquests.quest.QuestLine;
import online.pixelbuilt.pbquests.task.TaskTypes;
import online.pixelbuilt.pbquests.utils.Util;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class CommandManager {
    public static void registerCommands() {
        CommandSpec resetOneTime = CommandSpec.builder().description((Text)Text.of((String)"Resets one time quests of a specific quest line")).permission("pbq.command.reset").arguments(new CommandElement[]{QuestLineElement.create((Text)Text.of((String)"quest line")), GenericArguments.optional((CommandElement)GenericArguments.user((Text)Text.of((String)"player")))}).executor((sender, context) -> {
            QuestLine line = (QuestLine)context.getOne("quest line").get();
            User user = context.getOne("player").orElse(null);
            if (user == null) {
                if (sender instanceof Player) {
                    user = (User)sender;
                } else {
                    throw new CommandException((Text)Text.of((String)"Specify a player if running this command from console!"));
                }
            }
            List<Integer> quests = PixelBuiltQuests.getStorage().getQuestsRan(user.getUniqueId()).stream().filter(s -> s.split(",")[0].equalsIgnoreCase(line.getName())).map(s -> Integer.parseInt(s.split(",")[1])).filter(i -> {
                Quest quest = ConfigManager.getQuest(i);
                return quest != null && quest.tasks.stream().anyMatch(e -> e.getType() == TaskTypes.ONE_TIME);
            }).collect(Collectors.toList());
            User u = user;
            quests.forEach(i -> PixelBuiltQuests.getStorage().resetQuest(u.getUniqueId(), line, (int)i));
            sender.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully resetted oneTime quests!"}));
            return CommandResult.success();
        }).build();
        CommandSpec spawn = CommandSpec.builder().permission("pbq.command.spawn").arguments(GenericArguments.catalogedElement((Text)Text.of((String)"type"), EntityType.class)).executor((sender, context) -> {
            BlockRay blockRay = BlockRay.from((Entity)((Player)sender)).skipFilter(BlockRay.continueAfterFilter((Predicate)BlockRay.onlyAirFilter(), (int)1)).build();
            Optional hitOpt = blockRay.end();
            if (!hitOpt.isPresent()) {
                throw new CommandException((Text)Text.of((String)"You're not looking to a block!"));
            }
            EntityType entity = (EntityType)context.getOne("type").get();
            Entity npc = ((World)((BlockRayHit)hitOpt.get()).getExtent()).createEntity(entity, ((BlockRayHit)hitOpt.get()).getPosition());
            npc.offer(Keys.PERSISTS, (Object)true);
            npc.offer(Keys.AI_ENABLED, (Object)false);
            npc.offer(Keys.CUSTOM_NAME_VISIBLE, (Object)true);
            npc.offer(Keys.INVULNERABILITY_TICKS, (Object)Integer.MAX_VALUE);
            npc.offer(Keys.INVULNERABLE, (Object)true);
            npc.offer(Keys.HAS_GRAVITY, (Object)false);
            ((World)((BlockRayHit)hitOpt.get()).getExtent()).spawnEntity(npc);
            sender.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully spawned NPC! Assign a quest to it now!"}));
            return CommandResult.success();
        }).build();
        CommandSpec checkProgress = CommandSpec.builder().permission("pbq.command.checkprogress").arguments(new CommandElement[]{GenericArguments.userOrSource((Text)Text.of((String)"player")), QuestLineElement.create((Text)Text.of((String)"quest line"))}).executor((sender, context) -> {
            User user = (User)context.getOne("player").get();
            QuestLine line = (QuestLine)context.getOne("quest line").get();
            int progress = PixelBuiltQuests.getStorage().getProgress(user.getUniqueId(), line);
            sender.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Progress of ", TextColors.YELLOW, user.getName(), TextColors.GREEN, ": ", TextColors.YELLOW, progress}));
            return CommandResult.success();
        }).build();
        CommandSpec setProgress = CommandSpec.builder().permission("pbq.command.setprogress").arguments(new CommandElement[]{GenericArguments.userOrSource((Text)Text.of((String)"player")), QuestLineElement.create((Text)Text.of((String)"quest line")), GenericArguments.integer((Text)Text.of((String)"progress"))}).executor((sender, context) -> {
            User user = (User)context.getOne("player").get();
            QuestLine line = (QuestLine)context.getOne("quest line").get();
            int progress = (Integer)context.getOne("progress").get();
            PixelBuiltQuests.getStorage().setProgress(user.getUniqueId(), line, progress);
            sender.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully updated progress of ", TextColors.YELLOW, user.getName(), TextColors.GREEN, " to ", TextColors.YELLOW, progress, TextColors.GREEN, "!"}));
            return CommandResult.success();
        }).build();
        CommandSpec status = CommandSpec.builder().permission("pbq.command.status").arguments((CommandElement)QuestLineElement.create((Text)Text.of((String)"quest line"))).executor((sender, context) -> {
            if (!(sender instanceof Player)) {
                throw new CommandException((Text)Text.of((String)"This command can only be used by players!"));
            }
            Player p = (Player)sender;
            if (!Sponge.getPluginManager().isLoaded("pbqmessages")) {
                throw new CommandException((Text)Text.of((String)"You must load PBQMessages if you want to use this command!"));
            }
            QuestLine line = (QuestLine)context.getOne("quest line").get();
            int progress = PixelBuiltQuests.getStorage().getProgress(p.getUniqueId(), line);
            List messages = PBQMessages.getMessagesFor((String)line.getName(), (int)progress);
            if (messages != null && !messages.isEmpty()) {
                messages.forEach(msg -> p.sendMessage(Util.toText(msg)));
            }
            return CommandResult.success();
        }).build();
        CommandSpec addQuest = CommandSpec.builder().permission("pbq.command.addquest").arguments(GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.seq((CommandElement[])new CommandElement[]{QuestElement.create((Text)Text.of((String)"quest")), QuestLineElement.create((Text)Text.of((String)"quest line")), GenericArguments.enumValue((Text)Text.of((String)"walk/click"), Trigger.Type.class)}), GenericArguments.seq((CommandElement[])new CommandElement[]{QuestElement.create((Text)Text.of((String)"quest")), QuestLineElement.create((Text)Text.of((String)"quest line"))})})).executor((sender, context) -> {
            if (!(sender instanceof Player)) {
                throw new CommandException((Text)Text.of((String)"You must be a player to run this command!"));
            }
            Player p = (Player)sender;
            Quest quest = (Quest)context.getOne("quest").get();
            QuestLine line = (QuestLine)context.getOne("quest line").get();
            Optional optType = context.getOne("walk/click");
            if (optType.isPresent()) {
                Location loc = p.getLocation().sub(0.0, 1.0, 0.0);
                Trigger trigger = new Trigger((Location<World>)loc, quest, line, (Trigger.Type)((Object)((Object)optType.get())));
                PixelBuiltQuests.getStorage().addTrigger(trigger);
                sender.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully added trigger at ", Util.locationToText(trigger.getLocation())}));
            } else {
                sender.sendMessage(Text.of((Object[])new Object[]{TextColors.GRAY, "Right click the entity that you want to assign this quest to!"}));
                Sponge.getEventManager().registerListeners((Object)PixelBuiltQuests.instance, (Object)new OneTimeHandler((e, player) -> {
                    if (player.getUniqueId().equals(p.getUniqueId())) {
                        PixelBuiltQuests.getStorage().addNPC(e.getTargetEntity(), line, quest.getId());
                        sender.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully added NPC!"}));
                    }
                }));
            }
            return CommandResult.success();
        }).build();
        CommandSpec delete = CommandSpec.builder().permission("pbq.command.delete").arguments(GenericArguments.string((Text)Text.of((String)"block/npc"))).executor((sender, context) -> {
            if (!(sender instanceof Player)) {
                throw new CommandException((Text)Text.of((String)"You must be a player to run this!"));
            }
            Player p = (Player)sender;
            String type = (String)context.getOne("block/npc").get();
            if (type.equalsIgnoreCase("block")) {
                BlockRay blockRay = BlockRay.from((Entity)((Player)sender)).skipFilter(BlockRay.continueAfterFilter((Predicate)BlockRay.onlyAirFilter(), (int)1)).build();
                Optional hitOpt = blockRay.end();
                if (!hitOpt.isPresent()) throw new CommandException((Text)Text.of((String)"You're not looking to a block!"));
                Trigger trigger = PixelBuiltQuests.getStorage().getTriggerAt((Location<World>)((BlockRayHit)hitOpt.get()).getLocation());
                if (trigger == null) {
                    throw new CommandException((Text)Text.of((String)"Invalid trigger!"));
                }
                PixelBuiltQuests.getStorage().removeTrigger(trigger);
                sender.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully removed trigger!"}));
                return CommandResult.success();
            } else {
                if (!type.equalsIgnoreCase("npc")) throw new CommandException((Text)Text.of((String)"Unknown option! Specify block or npc!"));
                sender.sendMessage(Text.of((Object[])new Object[]{TextColors.GRAY, "Right click the entity the entity that you want to remove the trigger!"}));
                Sponge.getEventManager().registerListeners((Object)PixelBuiltQuests.instance, (Object)new OneTimeHandler((e, player) -> {
                    if (player.getUniqueId().equals(p.getUniqueId())) {
                        Tuple<Quest, QuestLine> quest = PixelBuiltQuests.getStorage().getQuest(e.getTargetEntity());
                        if (quest == null) {
                            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "There's no quest associated with this NPC!"}));
                        } else {
                            PixelBuiltQuests.getStorage().removeNPC(e.getTargetEntity());
                            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully removed quest from this entity!"}));
                        }
                    }
                }));
            }
            return CommandResult.success();
        }).build();
        CommandSpec rename = CommandSpec.builder().permission("pbq.command.rename").arguments(GenericArguments.text((Text)Text.of((String)"name"), (TextSerializer)TextSerializers.FORMATTING_CODE, (boolean)true)).executor((sender, context) -> {
            if (!(sender instanceof Player)) {
                throw new CommandException((Text)Text.of((String)"Only players can run this command!"));
            }
            Player p = (Player)sender;
            Text name = (Text)context.getOne("name").get();
            p.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Click in the entity that you want to rename!"}));
            Sponge.getEventManager().registerListeners((Object)PixelBuiltQuests.instance, (Object)new OneTimeHandler((e, player) -> {
                if (player.getUniqueId().equals(p.getUniqueId())) {
                    e.getTargetEntity().offer(Keys.DISPLAY_NAME, (Object)name);
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully renamed entity!"}));
                }
            }));
            return CommandResult.success();
        }).build();
        CommandSpec main = CommandSpec.builder().permission("pbq.command.main").executor((sender, context) -> {
            ArrayList text = Lists.newArrayList((Object[])new Text[]{CommandManager.cmd("pbq info <quest line>", "Shows your progress status in the specified quest line"), CommandManager.cmd("pbq setProgress <quest line> <progress> [<player>]", "Sets the progress of the player in the specified quest line"), CommandManager.cmd("pbq checkProgress [<player>] <quest line>", "Checks the progress of the player in the specific quest line"), CommandManager.cmd("pbq spawn <type>", "Spawns an NPC of the specified type. Use minecraft:villager if not sure"), CommandManager.cmd("pbq resetOneTime <quest line> [<player>]", "Resets the status of the one time quests of the player in the specified quest line"), CommandManager.cmd("pbq addQuest [<quest id> <quest line> <walk/click>], [<quest id> <quest line>]", "Adds a quest to a block/entity. If walk/click is specified, it will add the quest to the target block. If not, it will add the quest to the next clicked entity"), CommandManager.cmd("pbq delete <block/npc>", "Deletes the quest of the target block/entity"), CommandManager.cmd("pbq rename <name>", "Renames the next clicked entity to the specified name")});
            PaginationList.builder().title(Text.of((Object[])new Object[]{TextColors.YELLOW, "PBQ Commands"})).linesPerPage(19).contents((Iterable)text).sendTo((MessageReceiver)sender);
            return CommandResult.success();
        }).child((CommandCallable)status, new String[]{"status", "info"}).child((CommandCallable)setProgress, new String[]{"setProgress"}).child((CommandCallable)checkProgress, new String[]{"checkProgress"}).child((CommandCallable)spawn, new String[]{"spawn", "spawnnpc"}).child((CommandCallable)resetOneTime, new String[]{"resetOneTime"}).child((CommandCallable)addQuest, new String[]{"addQuest"}).child((CommandCallable)delete, new String[]{"delete"}).child((CommandCallable)rename, new String[]{"rename"}).build();
        Sponge.getCommandManager().register((Object)PixelBuiltQuests.instance, (CommandCallable)main, new String[]{"pbq", "pbquests"});
    }

    private static Text cmd(String command, String desc) {
        return Text.of((Object[])new Object[]{TextColors.YELLOW, "/" + command, TextColors.GRAY, " - ", TextColors.WHITE, desc});
    }

    public static class OneTimeHandler {
        private BiConsumer<InteractEntityEvent, Player> func;

        OneTimeHandler(BiConsumer<InteractEntityEvent, Player> function) {
            this.func = function;
        }

        @Listener(beforeModifications=true, order=Order.FIRST)
        public void onRightClick(InteractEntityEvent.Secondary.MainHand event, @Root Player player) {
            this.func.accept((InteractEntityEvent)event, player);
            event.setCancelled(true);
            Sponge.getEventManager().unregisterListeners((Object)this);
        }
    }

    private static class QuestElement
    extends CommandElement {
        public static QuestElement create(Text key) {
            return new QuestElement(key);
        }

        private QuestElement(Text key) {
            super(key);
        }

        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            try {
                int id = Integer.parseInt(args.next());
                Quest quest = ConfigManager.getQuest(id);
                if (quest == null) {
                    throw args.createError((Text)Text.of((String)"Invalid quest!"));
                }
                return quest;
            }
            catch (NumberFormatException e) {
                throw args.createError((Text)Text.of((String)"Invalid id!"));
            }
        }

        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return ConfigManager.getQuests().stream().map(Quest::getId).map(String::valueOf).collect(Collectors.toList());
        }

        public Text getUsage(CommandSource src) {
            return Text.of((String)"<quest id>");
        }
    }

    private static class QuestLineElement
    extends CommandElement {
        static QuestLineElement create(Text key) {
            return new QuestLineElement(key);
        }

        private QuestLineElement(Text key) {
            super(key);
        }

        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String line = args.next();
            QuestLine l = ConfigManager.getLine(line);
            if (l == null) {
                throw args.createError((Text)Text.of((String)"Invalid quest line!"));
            }
            return l;
        }

        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return ConfigManager.getLines().stream().map(QuestLine::getName).collect(Collectors.toList());
        }

        public Text getUsage(CommandSource src) {
            return Text.of((String)"<quest line>");
        }
    }
}

