/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests.utils;

import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import online.pixelbuilt.pbquests.BlockLocation;
import online.pixelbuilt.pbquests.PixelBuiltQuests;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataTranslators;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Config {
    private final PixelBuiltQuests instance;
    private final Path configFile;
    private final Path dataFile;
    private ConfigurationNode rootNode;
    private ConfigurationLoader<CommentedConfigurationNode> loader;
    private TypeToken<Map<String, String>> typeToken;
    private ConfigurationNode dataNode;
    public List<BlockType> blocks;

    public Config(PixelBuiltQuests instance, Path configFile, Path configDir) {
        this.instance = instance;
        this.configFile = configFile;
        this.dataFile = Paths.get(configDir.toString(), "data.nbt");
    }

    public void load() {
        Object object;
        if (!this.configFile.toFile().exists()) {
            try {
                ((Asset)Sponge.getAssetManager().getAsset((Object)this.instance, "PBQuests.conf").get()).copyToFile(this.configFile);
            }
            catch (IOException | NoSuchElementException e) {
                PixelBuiltQuests.logger.error("Could not create the default config! Report it in the plugin issue tracker, and include this stacktrace: ");
                e.printStackTrace();
                return;
            }
        }
        if (!this.dataFile.toFile().exists()) {
            try {
                OutputStream os = Files.newOutputStream(this.dataFile, new OpenOption[0]);
                object = null;
                try {
                    DataFormats.NBT.writeTo(os, (DataView)new MemoryDataContainer());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (os != null) {
                        if (object != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            InputStream is = Files.newInputStream(this.dataFile, new OpenOption[0]);
            object = null;
            try {
                DataContainer container = DataFormats.NBT.readFrom(is);
                this.dataNode = (ConfigurationNode)DataTranslators.CONFIGURATION_NODE.translate((DataView)container);
            }
            catch (Throwable container) {
                object = container;
                throw container;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable container) {
                            ((Throwable)object).addSuppressed(container);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.configFile)).build();
        try {
            this.rootNode = this.loader.load();
        }
        catch (IOException e) {
            PixelBuiltQuests.logger.error("Could not load the default config! Report it in the plugin issue tracker, and include this stacktrace: ");
            e.printStackTrace();
            return;
        }
        this.blocks = new ArrayList<BlockType>();
        try {
            List typeStrings = this.rootNode.getNode(new Object[]{"triggers"}).getList(TypeToken.of(String.class));
            for (String type : typeStrings) {
                if (!Sponge.getRegistry().getType(BlockType.class, type).isPresent()) continue;
                this.blocks.add((BlockType)Sponge.getRegistry().getType(BlockType.class, type).get());
            }
        }
        catch (ObjectMappingException objectMappingException) {
            // empty catch block
        }
        this.typeToken = new TypeToken<Map<String, String>>(){};
        PixelBuiltQuests.logger.info("Config loaded successfully!");
    }

    public void addTrigger(Location<World> location, String questLine, int questId) {
        try {
            this.dataNode.getNode(new Object[]{"data"}).getAppendedNode().setValue(BlockLocation.type, (Object)new BlockLocation(location, questLine, questId));
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
        Task.builder().execute(() -> {
            DataContainer container = DataTranslators.CONFIGURATION_NODE.translate((Object)this.dataNode.getNode(new Object[]{"data"}));
            try (OutputStream os = Files.newOutputStream(this.dataFile, new OpenOption[0]);){
                DataFormats.NBT.writeTo(os, (DataView)container);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).async().submit((Object)PixelBuiltQuests.instance);
    }

    public boolean hasTrigger(Location<World> location) {
        try {
            if (this.dataNode.getNode(new Object[]{"data"}).getList(TypeToken.of(BlockLocation.class)).stream().anyMatch(loc -> loc.x == location.getBlockX() && loc.y == location.getBlockY() && loc.z == location.getBlockZ() && loc.world.equals(((World)location.getExtent()).getUniqueId()))) {
                return true;
            }
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getQuestLine(Location<World> loc) {
        try {
            return this.dataNode.getNode((Object[])new Object[]{"data"}).getList((TypeToken)TypeToken.of(BlockLocation.class)).stream().filter((Predicate<BlockLocation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getQuestLine$2(org.spongepowered.api.world.Location online.pixelbuilt.pbquests.BlockLocation ), (Lonline/pixelbuilt/pbquests/BlockLocation;)Z)(loc)).findFirst().get().questLine;
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public int getQuestId(Location<World> loc) {
        try {
            return this.dataNode.getNode((Object[])new Object[]{"data"}).getList((TypeToken)TypeToken.of(BlockLocation.class)).stream().filter((Predicate<BlockLocation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getQuestId$3(org.spongepowered.api.world.Location online.pixelbuilt.pbquests.BlockLocation ), (Lonline/pixelbuilt/pbquests/BlockLocation;)Z)(loc)).findFirst().get().questId;
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String getString(Object ... key) {
        String string = null;
        try {
            string = this.rootNode.getNode(key).getString();
        }
        catch (Exception e) {
            PixelBuiltQuests.logger.error("Could not retrieve a specific String!");
            PixelBuiltQuests.logger.error("String key: " + Arrays.toString(key));
            PixelBuiltQuests.logger.error("Stacktrace: " + e);
        }
        return string;
    }

    public ConfigurationNode getQuestNode(String questLine, int questID) {
        return this.rootNode.getNode(new Object[]{"quests", questLine, Integer.toString(questID)});
    }

    private static /* synthetic */ boolean lambda$getQuestId$3(Location loc, BlockLocation location) {
        return location.x == loc.getBlockX() && location.y == loc.getBlockY() && location.z == loc.getBlockZ() && location.world.toString().equals(((World)loc.getExtent()).getUniqueId().toString());
    }

    private static /* synthetic */ boolean lambda$getQuestLine$2(Location loc, BlockLocation location) {
        return location.x == loc.getBlockX() && location.y == loc.getBlockY() && location.z == loc.getBlockZ() && location.world.toString().equals(((World)loc.getExtent()).getUniqueId().toString());
    }
}

