/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Objects;
import net.buycraft.plugin.BuyCraftAPIException;
import net.buycraft.plugin.data.Coupon;
import net.buycraft.plugin.data.GiftCard;
import net.buycraft.plugin.data.RecentPayment;
import net.buycraft.plugin.data.ServerEvent;
import net.buycraft.plugin.data.responses.BuycraftError;
import net.buycraft.plugin.data.responses.CheckoutUrlResponse;
import net.buycraft.plugin.data.responses.CouponListing;
import net.buycraft.plugin.data.responses.CouponSingleListing;
import net.buycraft.plugin.data.responses.DueQueueInformation;
import net.buycraft.plugin.data.responses.GiftCardListing;
import net.buycraft.plugin.data.responses.GiftCardSingleListing;
import net.buycraft.plugin.data.responses.Listing;
import net.buycraft.plugin.data.responses.QueueInformation;
import net.buycraft.plugin.data.responses.ServerInformation;
import net.buycraft.plugin.internal.okhttp3.FormBody;
import net.buycraft.plugin.internal.okhttp3.Interceptor;
import net.buycraft.plugin.internal.okhttp3.OkHttpClient;
import net.buycraft.plugin.internal.okhttp3.Request;
import net.buycraft.plugin.internal.okhttp3.RequestBody;
import net.buycraft.plugin.internal.okhttp3.Response;
import net.buycraft.plugin.internal.okhttp3.ResponseBody;
import net.buycraft.plugin.internal.retrofit2.Call;
import net.buycraft.plugin.internal.retrofit2.Retrofit;
import net.buycraft.plugin.internal.retrofit2.converter.gson.GsonConverterFactory;
import net.buycraft.plugin.internal.retrofit2.http.Body;
import net.buycraft.plugin.internal.retrofit2.http.DELETE;
import net.buycraft.plugin.internal.retrofit2.http.Field;
import net.buycraft.plugin.internal.retrofit2.http.FormUrlEncoded;
import net.buycraft.plugin.internal.retrofit2.http.GET;
import net.buycraft.plugin.internal.retrofit2.http.HTTP;
import net.buycraft.plugin.internal.retrofit2.http.POST;
import net.buycraft.plugin.internal.retrofit2.http.PUT;
import net.buycraft.plugin.internal.retrofit2.http.Path;
import net.buycraft.plugin.internal.retrofit2.http.Query;

public interface BuyCraftAPI {
    public static final String API_URL = "https://plugin.buycraft.net";
    public static final String API_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssX";
    public static final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssX").create();

    public static BuyCraftAPI create(String secret) {
        return BuyCraftAPI.create(secret, null);
    }

    public static BuyCraftAPI create(final String secret, OkHttpClient client) {
        OkHttpClient.Builder clientBuilder = client != null ? client.newBuilder() : new OkHttpClient.Builder();
        return new Retrofit.Builder().baseUrl(API_URL).addConverterFactory(GsonConverterFactory.create(gson)).client(clientBuilder.addInterceptor(new Interceptor(){

            @Override
            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request request = original.newBuilder().header("X-Buycraft-Secret", secret).header("Accept", "application/json").header("User-Agent", "BuycraftX").method(original.method(), original.body()).build();
                return chain.proceed(request);
            }
        }).addInterceptor(new Interceptor(){

            @Override
            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response response = chain.proceed(chain.request());
                if (!response.isSuccessful()) {
                    ResponseBody body = response.body();
                    if (body == null) {
                        throw new BuyCraftAPIException("Unknown error occurred whilst deserializing error object.", response.request(), response, "");
                    }
                    String in = body.string();
                    if (!Objects.equals(response.header("Content-Type"), "application/json")) {
                        throw new BuyCraftAPIException("Unexpected content-type " + response.header("Content-Type"), response.request(), response, in);
                    }
                    BuycraftError error = (BuycraftError)gson.fromJson(in, BuycraftError.class);
                    if (error != null) {
                        throw new BuyCraftAPIException(error.getErrorMessage(), response.request(), response, in);
                    }
                    throw new BuyCraftAPIException("Unknown error occurred whilst deserializing error object.", response.request(), response, in);
                }
                return response;
            }
        }).build()).build().create(BuyCraftAPI.class);
    }

    @GET(value="/information")
    public Call<ServerInformation> getServerInformation();

    @GET(value="/listing")
    public Call<Listing> retrieveListing();

    @GET(value="/queue")
    public Call<DueQueueInformation> retrieveDueQueue();

    @GET(value="/queue/offline-commands")
    public Call<QueueInformation> retrieveOfflineQueue();

    @GET(value="/queue/online-commands/{id}")
    public Call<QueueInformation> getPlayerQueue(@Path(value="id") int var1);

    @FormUrlEncoded
    @HTTP(method="DELETE", path="/queue", hasBody=true)
    public Call<Void> deleteCommands(@Field(value="ids[]") List<Integer> var1);

    @FormUrlEncoded
    @POST(value="/checkout")
    public Call<CheckoutUrlResponse> getCheckoutUri(@Field(value="username") String var1, @Field(value="package_id") int var2);

    @FormUrlEncoded
    @POST(value="/checkout")
    public Call<CheckoutUrlResponse> getCategoryUri(@Field(value="username") String var1, @Field(value="category_id") int var2);

    @GET(value="/payments")
    public Call<List<RecentPayment>> getRecentPayments(@Query(value="limit") int var1);

    @GET(value="/coupons")
    public Call<CouponListing> getAllCoupons();

    @GET(value="/coupons/{id}")
    public Call<Coupon> getCoupon(@Path(value="id") int var1);

    @DELETE(value="/coupons/{id}")
    public Call<Void> deleteCoupon(@Path(value="id") int var1);

    @DELETE(value="/coupons/{id}/code")
    public Call<Void> deleteCoupon(@Path(value="id") String var1);

    default public Call<CouponSingleListing> createCoupon(Coupon coupon) {
        FormBody.Builder build = new FormBody.Builder().add("code", coupon.getCode()).add("effective_on", coupon.getEffective().getType());
        switch (coupon.getEffective().getType()) {
            case "packages": {
                for (Integer id1 : coupon.getEffective().getPackages()) {
                    build.add("packages[]", Integer.toString(id1));
                }
                break;
            }
            case "categories": {
                for (Integer id2 : coupon.getEffective().getCategories()) {
                    build.add("categories[]", Integer.toString(id2));
                }
                break;
            }
        }
        FormBody body = build.add("discount_type", coupon.getDiscount().getType()).add("discount_amount", coupon.getDiscount().getValue().toPlainString()).add("discount_percentage", coupon.getDiscount().getPercentage().toPlainString()).add("expire_type", coupon.getExpire().getType()).add("expire_limit", Integer.toString(coupon.getExpire().getLimit())).add("expire_date", new SimpleDateFormat(API_DATE_FORMAT).format(coupon.getExpire().getDate())).add("start_date", new SimpleDateFormat(API_DATE_FORMAT).format(coupon.getStartDate())).add("basket_type", coupon.getBasketType()).add("minimum", coupon.getMinimum().toPlainString()).add("redeem_limit", Integer.toString(coupon.getUserLimit())).add("discount_application_method", Integer.toString(coupon.getDiscountMethod())).add("redeem_unlimited", coupon.getRedeemUnlimited() + "").add("expire_never", coupon.getExpireNever() + "").add("username", coupon.getUsername() == null ? "" : coupon.getUsername()).add("note", coupon.getNote() == null ? "" : coupon.getNote()).build();
        return this.createCoupon(body);
    }

    @POST(value="/coupons")
    public Call<CouponSingleListing> createCoupon(@Body RequestBody var1);

    @GET(value="/gift-cards")
    public Call<GiftCardListing> getAllGiftCards();

    @GET(value="/gift-cards/{id}")
    public Call<GiftCardSingleListing> getGiftCard(@Path(value="id") int var1);

    @DELETE(value="/gift-cards/{id}")
    public Call<GiftCardSingleListing> voidGiftCard(@Path(value="id") int var1);

    default public Call<GiftCardSingleListing> topUpGiftCard(int id, BigDecimal amount) {
        return this.topUpGiftCard(id, new FormBody.Builder().add("amount", amount.toPlainString()).build());
    }

    @PUT(value="/gift-cards/{id}")
    public Call<GiftCardSingleListing> topUpGiftCard(@Path(value="id") int var1, @Body RequestBody var2);

    default public Call<GiftCardSingleListing> createGiftCard(BigDecimal amount, String note) {
        return this.createGiftCard(new FormBody.Builder().add("amount", amount.toPlainString()).add("note", note).build());
    }

    default public Call<GiftCardSingleListing> createGiftCard(GiftCard giftCard) {
        return this.createGiftCard(new FormBody.Builder().add("amount", giftCard.getBalance().getStarting().toPlainString()).add("note", giftCard.getNote()).build());
    }

    @POST(value="/gift-cards")
    public Call<GiftCardSingleListing> createGiftCard(@Body RequestBody var1);

    @POST(value="/events")
    public Call<Void> sendEvents(@Body List<ServerEvent> var1);
}

