/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.buycraft.plugin.data.Package;

public final class Category
implements Comparable<Category> {
    private final int id;
    private final int order;
    private final String name;
    private final List<Package> packages;
    private final List<Category> subcategories;
    @SerializedName(value="gui_item")
    private final String guiItem;

    public Category(int id, int order, String name, List<Package> packages, List<Category> subcategories, String guiItem) {
        this.id = id;
        this.order = order;
        this.name = name;
        this.packages = packages;
        this.subcategories = subcategories;
        this.guiItem = guiItem;
    }

    @Override
    public int compareTo(Category o) {
        Objects.requireNonNull(o, "category");
        return Integer.compare(this.order, o.getOrder());
    }

    public List<Category> getSubcategories() {
        return this.subcategories == null ? ImmutableList.of() : this.subcategories;
    }

    public void order() {
        this.packages.sort(Comparator.comparingInt(Package::getOrder));
        if (this.subcategories != null) {
            this.subcategories.sort(Comparator.comparingInt(Category::getOrder));
            for (Category category : this.subcategories) {
                category.order();
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public int getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public List<Package> getPackages() {
        return this.packages;
    }

    public String getGuiItem() {
        return this.guiItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Category category = (Category)o;
        if (this.id != category.id) {
            return false;
        }
        if (this.order != category.order) {
            return false;
        }
        if (!Objects.equals(this.name, category.name)) {
            return false;
        }
        if (!Objects.equals(this.packages, category.packages)) {
            return false;
        }
        if (!Objects.equals(this.subcategories, category.subcategories)) {
            return false;
        }
        return Objects.equals(this.guiItem, category.guiItem);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.order;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.packages != null ? this.packages.hashCode() : 0);
        result = 31 * result + (this.subcategories != null ? this.subcategories.hashCode() : 0);
        result = 31 * result + (this.guiItem != null ? this.guiItem.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Category(id=" + this.getId() + ", order=" + this.getOrder() + ", name=" + this.getName() + ", packages=" + this.getPackages() + ", subcategories=" + this.getSubcategories() + ", guiItem=" + this.getGuiItem() + ")";
    }
}

