/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.data;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public final class Coupon {
    private final int id;
    private final String code;
    private final Effective effective;
    private final Discount discount;
    private final Expire expire;
    @SerializedName(value="basket_type")
    private final String basketType;
    @SerializedName(value="start_date")
    private final Date startDate;
    @SerializedName(value="user_limit")
    private final int userLimit;
    @SerializedName(value="discount_application_method")
    private final int discountMethod;
    @SerializedName(value="expire_never")
    private final boolean expireNever;
    @SerializedName(value="redeem_unlimited")
    private final boolean redeemUnlimited;
    private final BigDecimal minimum;
    @SerializedName(value="username")
    private final String username;
    @SerializedName(value="note")
    private final String note;

    Coupon(int id, String code, Effective effective, Discount discount, Expire expire, String basketType, Date startDate, int userLimit, int discountMethod, boolean expireNever, boolean redeemUnlimited, BigDecimal minimum, String username, String note) {
        this.id = id;
        this.code = code;
        this.effective = effective;
        this.discount = discount;
        this.expire = expire;
        this.basketType = basketType;
        this.startDate = startDate;
        this.userLimit = userLimit;
        this.discountMethod = discountMethod;
        this.expireNever = expireNever;
        this.redeemUnlimited = redeemUnlimited;
        this.minimum = minimum;
        this.username = username;
        this.note = note;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public Effective getEffective() {
        return this.effective;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public Expire getExpire() {
        return this.expire;
    }

    public String getBasketType() {
        return this.basketType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public int getUserLimit() {
        return this.userLimit;
    }

    public int getDiscountMethod() {
        return this.discountMethod;
    }

    public boolean getExpireNever() {
        return this.expireNever;
    }

    public boolean getRedeemUnlimited() {
        return this.redeemUnlimited;
    }

    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public String getUsername() {
        return this.username;
    }

    public String getNote() {
        return this.note;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coupon coupon = (Coupon)o;
        if (this.id != coupon.id) {
            return false;
        }
        if (this.userLimit != coupon.userLimit) {
            return false;
        }
        if (this.discountMethod != coupon.discountMethod) {
            return false;
        }
        if (this.expireNever != coupon.expireNever) {
            return false;
        }
        if (this.redeemUnlimited != coupon.redeemUnlimited) {
            return false;
        }
        if (!Objects.equals(this.code, coupon.code)) {
            return false;
        }
        if (!Objects.equals(this.effective, coupon.effective)) {
            return false;
        }
        if (!Objects.equals(this.discount, coupon.discount)) {
            return false;
        }
        if (!Objects.equals(this.expire, coupon.expire)) {
            return false;
        }
        if (!Objects.equals(this.basketType, coupon.basketType)) {
            return false;
        }
        if (!Objects.equals(this.startDate, coupon.startDate)) {
            return false;
        }
        if (!Objects.equals(this.minimum, coupon.minimum)) {
            return false;
        }
        if (!Objects.equals(this.username, coupon.username)) {
            return false;
        }
        return Objects.equals(this.note, coupon.note);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
        result = 31 * result + (this.effective != null ? this.effective.hashCode() : 0);
        result = 31 * result + (this.discount != null ? this.discount.hashCode() : 0);
        result = 31 * result + (this.expire != null ? this.expire.hashCode() : 0);
        result = 31 * result + (this.basketType != null ? this.basketType.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + this.userLimit;
        result = 31 * result + this.discountMethod;
        result = 31 * result + (this.expireNever ? 1 : 0);
        result = 31 * result + (this.redeemUnlimited ? 1 : 0);
        result = 31 * result + (this.minimum != null ? this.minimum.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.note != null ? this.note.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Coupon(id=" + this.getId() + ", code=" + this.getCode() + ", effective=" + this.getEffective() + ", discount=" + this.getDiscount() + ", expire=" + this.getExpire() + ", basketType=" + this.getBasketType() + ", startDate=" + this.getStartDate() + ", userLimit=" + this.getUserLimit() + ", discountMethod=" + this.getDiscountMethod() + ", expireNever=" + this.getExpireNever() + ", redeemUnlimited=" + this.getRedeemUnlimited() + ", minimum=" + this.getMinimum() + ", username=" + this.getUsername() + ", note=" + this.getNote() + ")";
    }

    public static class Builder {
        private int id;
        private String code;
        private Effective effective;
        private Discount discount;
        private Expire expire;
        private String basketType;
        private Date startDate;
        private int userLimit;
        private int discountMethod;
        private boolean expireNever;
        private boolean redeemUnlimited;
        private BigDecimal minimum;
        private String username;
        private String note;

        Builder() {
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder effective(Effective effective) {
            this.effective = effective;
            return this;
        }

        public Builder discount(Discount discount) {
            this.discount = discount;
            return this;
        }

        public Builder expire(Expire expire) {
            this.expire = expire;
            return this;
        }

        public Builder basketType(String basketType) {
            this.basketType = basketType;
            return this;
        }

        public Builder startDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder userLimit(int userLimit) {
            this.userLimit = userLimit;
            return this;
        }

        public Builder discountMethod(int discountMethod) {
            this.discountMethod = discountMethod;
            return this;
        }

        public Builder expireNever(boolean expireNever) {
            this.expireNever = expireNever;
            return this;
        }

        public Builder expireNever(int expireNever) {
            this.expireNever = expireNever == 1;
            return this;
        }

        public Builder redeemUnlimited(boolean redeemUnlimited) {
            this.redeemUnlimited = redeemUnlimited;
            return this;
        }

        public Builder redeemUnlimited(int redeemUnlimited) {
            this.redeemUnlimited = redeemUnlimited == 1;
            return this;
        }

        public Builder minimum(BigDecimal minimum) {
            this.minimum = minimum;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public Coupon build() {
            return new Coupon(this.id, this.code, this.effective, this.discount, this.expire, this.basketType, this.startDate, this.userLimit, this.discountMethod, this.expireNever, this.redeemUnlimited, this.minimum, this.username, this.note);
        }

        public String toString() {
            return "Coupon.Builder(id=" + this.id + ", code=" + this.code + ", effective=" + this.effective + ", discount=" + this.discount + ", expire=" + this.expire + ", basketType=" + this.basketType + ", startDate=" + this.startDate + ", userLimit=" + this.userLimit + ", discountMethod=" + this.discountMethod + ", expireNever=" + this.expireNever + ", redeemUnlimited=" + this.redeemUnlimited + ", minimum=" + this.minimum + ", username=" + this.username + ", note=" + this.note + ")";
        }
    }

    public static final class Expire {
        private final String type;
        private final int limit;
        private final Date date;

        public Expire(String type, int limit, Date date) {
            this.type = type;
            this.limit = limit;
            this.date = date;
        }

        public String getType() {
            return this.type;
        }

        public int getLimit() {
            return this.limit;
        }

        public Date getDate() {
            return this.date;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Expire expire = (Expire)o;
            if (this.limit != expire.limit) {
                return false;
            }
            if (!Objects.equals(this.type, expire.type)) {
                return false;
            }
            return Objects.equals(this.date, expire.date);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + this.limit;
            result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Coupon.Expire(type=" + this.getType() + ", limit=" + this.getLimit() + ", date=" + this.getDate() + ")";
        }
    }

    public static final class Discount {
        private final String type;
        private final BigDecimal percentage;
        private final BigDecimal value;

        public Discount(String type, BigDecimal percentage, BigDecimal value) {
            this.type = type;
            this.percentage = percentage;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public BigDecimal getPercentage() {
            return this.percentage;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Discount discount = (Discount)o;
            if (!Objects.equals(this.type, discount.type)) {
                return false;
            }
            if (!Objects.equals(this.percentage, discount.percentage)) {
                return false;
            }
            return Objects.equals(this.value, discount.value);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.percentage != null ? this.percentage.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Coupon.Discount(type=" + this.getType() + ", percentage=" + this.getPercentage() + ", value=" + this.getValue() + ")";
        }
    }

    public static final class Effective {
        private final String type;
        private final List<Integer> packages;
        private final List<Integer> categories;

        public Effective(String type, List<Integer> packages, List<Integer> categories) {
            this.type = type;
            this.packages = packages;
            this.categories = categories;
        }

        public String getType() {
            return this.type;
        }

        public List<Integer> getPackages() {
            return this.packages;
        }

        public List<Integer> getCategories() {
            return this.categories;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Effective effective = (Effective)o;
            if (!Objects.equals(this.type, effective.type)) {
                return false;
            }
            if (!Objects.equals(this.packages, effective.packages)) {
                return false;
            }
            return Objects.equals(this.categories, effective.categories);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.packages != null ? this.packages.hashCode() : 0);
            result = 31 * result + (this.categories != null ? this.categories.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Coupon.Effective(type=" + this.getType() + ", packages=" + this.getPackages() + ", categories=" + this.getCategories() + ")";
        }
    }
}

