/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.data;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;

public final class GiftCard {
    private final int id = -1;
    private final String code;
    private final Balance balance;
    private final String note;
    @SerializedName(value="void")
    private final boolean isVoid = false;

    GiftCard(BigDecimal amount, String note) {
        this.code = null;
        this.balance = new Balance(amount);
        this.note = note;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public int getId() {
        return -1;
    }

    public String getCode() {
        return this.code;
    }

    public Balance getBalance() {
        return this.balance;
    }

    public String getNote() {
        return this.note;
    }

    public boolean isVoid() {
        return false;
    }

    public static class Builder {
        private BigDecimal amount;
        private String note;

        Builder() {
        }

        public Builder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public GiftCard build() {
            return new GiftCard(this.amount, this.note);
        }

        public String toString() {
            return "GiftCard.Builder(amount=" + this.amount + ", note=" + this.note + ")";
        }
    }

    public static final class Balance {
        private final BigDecimal starting;
        private final BigDecimal remaining;
        private final String currency;

        Balance(BigDecimal base) {
            this.currency = null;
            this.starting = base;
            this.remaining = base;
        }

        public BigDecimal getStarting() {
            return this.starting;
        }

        public BigDecimal getRemaining() {
            return this.remaining;
        }

        public String getCurrency() {
            return this.currency;
        }
    }
}

