/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.data;

import java.math.BigDecimal;
import java.util.Objects;

public final class Package
implements Comparable<Package> {
    private final int id;
    private final int order;
    private final String name;
    private final BigDecimal price;
    private final Sale sale;
    private final String gui_item;

    public Package(int id, int order, String name, BigDecimal price, Sale sale, String gui_item) {
        this.id = id;
        this.order = order;
        this.name = name;
        this.price = price;
        this.sale = sale;
        this.gui_item = gui_item;
    }

    @Override
    public int compareTo(Package o) {
        Objects.requireNonNull(o, "package");
        return Integer.compare(this.order, o.getOrder());
    }

    public BigDecimal getEffectivePrice() {
        BigDecimal rounded = this.price.setScale(2, 4);
        if (this.sale == null) {
            return rounded;
        }
        return rounded.subtract(this.sale.getDiscount().setScale(2, 4));
    }

    public int getId() {
        return this.id;
    }

    public int getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public Sale getSale() {
        return this.sale;
    }

    public String getGuiItem() {
        return this.gui_item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Package aPackage = (Package)o;
        if (this.id != aPackage.id) {
            return false;
        }
        if (this.order != aPackage.order) {
            return false;
        }
        if (!Objects.equals(this.name, aPackage.name)) {
            return false;
        }
        if (!Objects.equals(this.price, aPackage.price)) {
            return false;
        }
        if (!Objects.equals(this.sale, aPackage.sale)) {
            return false;
        }
        return Objects.equals(this.gui_item, aPackage.gui_item);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.order;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.price != null ? this.price.hashCode() : 0);
        result = 31 * result + (this.sale != null ? this.sale.hashCode() : 0);
        result = 31 * result + (this.gui_item != null ? this.gui_item.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Package(id=" + this.getId() + ", order=" + this.getOrder() + ", name=" + this.getName() + ", price=" + this.getPrice() + ", sale=" + this.getSale() + ", gui_item=" + this.getGuiItem() + ")";
    }

    public static final class Sale {
        private final boolean active;
        private final BigDecimal discount;

        public Sale(boolean active, BigDecimal discount) {
            this.active = active;
            this.discount = discount;
        }

        public boolean isActive() {
            return this.active;
        }

        public BigDecimal getDiscount() {
            return this.discount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Sale sale = (Sale)o;
            if (this.active != sale.active) {
                return false;
            }
            return Objects.equals(this.discount, sale.discount);
        }

        public int hashCode() {
            int result = this.active ? 1 : 0;
            result = 31 * result + (this.discount != null ? this.discount.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Package.Sale(active=" + this.isActive() + ", discount=" + this.getDiscount() + ")";
        }
    }
}

