/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import net.buycraft.plugin.data.QueuedPlayer;
import net.buycraft.plugin.data.responses.ServerInformation;

public final class RecentPayment {
    private final int id;
    private final BigDecimal amount;
    private final Date date;
    private final ServerInformation.AccountCurrency currency;
    private final QueuedPlayer player;

    public RecentPayment(int id, BigDecimal amount, Date date, ServerInformation.AccountCurrency currency, QueuedPlayer player) {
        this.id = id;
        this.amount = amount;
        this.date = date;
        this.currency = currency;
        this.player = player;
    }

    public int getId() {
        return this.id;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Date getDate() {
        return this.date;
    }

    public ServerInformation.AccountCurrency getCurrency() {
        return this.currency;
    }

    public QueuedPlayer getPlayer() {
        return this.player;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecentPayment that = (RecentPayment)o;
        if (this.id != that.id) {
            return false;
        }
        if (!Objects.equals(this.amount, that.amount)) {
            return false;
        }
        if (!Objects.equals(this.date, that.date)) {
            return false;
        }
        if (!Objects.equals(this.currency, that.currency)) {
            return false;
        }
        return Objects.equals(this.player, that.player);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.player != null ? this.player.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RecentPayment(id=" + this.getId() + ", amount=" + this.getAmount() + ", date=" + this.getDate() + ", currency=" + this.getCurrency() + ", player=" + this.getPlayer() + ")";
    }
}

