/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.data.responses;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Objects;
import net.buycraft.plugin.data.QueuedPlayer;

public final class DueQueueInformation {
    private final QueueInformationMeta meta;
    private final List<QueuedPlayer> players;

    public DueQueueInformation(QueueInformationMeta meta, List<QueuedPlayer> players) {
        this.meta = meta;
        this.players = players;
    }

    public QueueInformationMeta getMeta() {
        return this.meta;
    }

    public List<QueuedPlayer> getPlayers() {
        return this.players;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DueQueueInformation that = (DueQueueInformation)o;
        if (!Objects.equals(this.meta, that.meta)) {
            return false;
        }
        return Objects.equals(this.players, that.players);
    }

    public int hashCode() {
        int result = this.meta != null ? this.meta.hashCode() : 0;
        result = 31 * result + (this.players != null ? this.players.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DueQueueInformation(meta=" + this.getMeta() + ", players=" + this.getPlayers() + ")";
    }

    public static final class QueueInformationMeta {
        @SerializedName(value="execute_offline")
        private final boolean executeOffline;
        @SerializedName(value="next_check")
        private final int nextCheck;
        private final boolean more;

        public QueueInformationMeta(boolean executeOffline, int nextCheck, boolean more) {
            this.executeOffline = executeOffline;
            this.nextCheck = nextCheck;
            this.more = more;
        }

        public boolean isExecuteOffline() {
            return this.executeOffline;
        }

        public int getNextCheck() {
            return this.nextCheck;
        }

        public boolean isMore() {
            return this.more;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueueInformationMeta that = (QueueInformationMeta)o;
            if (this.executeOffline != that.executeOffline) {
                return false;
            }
            if (this.nextCheck != that.nextCheck) {
                return false;
            }
            return this.more == that.more;
        }

        public int hashCode() {
            int result = this.executeOffline ? 1 : 0;
            result = 31 * result + this.nextCheck;
            result = 31 * result + (this.more ? 1 : 0);
            return result;
        }

        public String toString() {
            return "DueQueueInformation.QueueInformationMeta(executeOffline=" + this.isExecuteOffline() + ", nextCheck=" + this.getNextCheck() + ", more=" + this.isMore() + ")";
        }
    }
}

