/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.data.responses;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

public final class ServerInformation {
    private final Account account;
    private final Server server;

    public ServerInformation(Account account, Server server) {
        this.account = account;
        this.server = server;
    }

    public Account getAccount() {
        return this.account;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerInformation that = (ServerInformation)o;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        return Objects.equals(this.server, that.server);
    }

    public int hashCode() {
        int result = this.account != null ? this.account.hashCode() : 0;
        result = 31 * result + (this.server != null ? this.server.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServerInformation(account=" + this.getAccount() + ", server=" + this.getServer() + ")";
    }

    public static final class AccountCurrency {
        @SerializedName(value="iso_4217")
        private final String iso4217;
        private final String symbol;

        public AccountCurrency(String iso4217, String symbol) {
            this.iso4217 = iso4217;
            this.symbol = symbol;
        }

        public String getIso4217() {
            return this.iso4217;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccountCurrency that = (AccountCurrency)o;
            if (!Objects.equals(this.iso4217, that.iso4217)) {
                return false;
            }
            return Objects.equals(this.symbol, that.symbol);
        }

        public int hashCode() {
            int result = this.iso4217 != null ? this.iso4217.hashCode() : 0;
            result = 31 * result + (this.symbol != null ? this.symbol.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ServerInformation.AccountCurrency(iso4217=" + this.getIso4217() + ", symbol=" + this.getSymbol() + ")";
        }
    }

    public static final class Server {
        private final int id;
        private final String name;

        public Server(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Server server = (Server)o;
            if (this.id != server.id) {
                return false;
            }
            return Objects.equals(this.name, server.name);
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ServerInformation.Server(id=" + this.getId() + ", name=" + this.getName() + ")";
        }
    }

    public static final class Account {
        private final int id;
        private final String domain;
        private final String name;
        private final AccountCurrency currency;
        @SerializedName(value="online_mode")
        private final boolean onlineMode;
        @SerializedName(value="log_events")
        private final boolean logEvents;

        public Account(int id, String domain, String name, AccountCurrency currency, boolean onlineMode, boolean logEvents) {
            this.id = id;
            this.domain = domain;
            this.name = name;
            this.currency = currency;
            this.onlineMode = onlineMode;
            this.logEvents = logEvents;
        }

        public int getId() {
            return this.id;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getName() {
            return this.name;
        }

        public AccountCurrency getCurrency() {
            return this.currency;
        }

        public boolean isOnlineMode() {
            return this.onlineMode;
        }

        public boolean isLogEvents() {
            return this.logEvents;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Account account = (Account)o;
            if (this.id != account.id) {
                return false;
            }
            if (this.onlineMode != account.onlineMode) {
                return false;
            }
            if (this.logEvents != account.logEvents) {
                return false;
            }
            if (!Objects.equals(this.domain, account.domain)) {
                return false;
            }
            if (!Objects.equals(this.name, account.name)) {
                return false;
            }
            return Objects.equals(this.currency, account.currency);
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
            result = 31 * result + (this.onlineMode ? 1 : 0);
            result = 31 * result + (this.logEvents ? 1 : 0);
            return result;
        }

        public String toString() {
            return "Account(id=" + this.id + ", domain='" + this.domain + '\'' + ", name='" + this.name + '\'' + ", currency=" + this.currency + ", onlineMode=" + this.onlineMode + ", logEvents=" + this.logEvents + ')';
        }
    }
}

