/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.execution;

import java.io.IOException;
import java.util.logging.Level;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.data.QueuedCommand;
import net.buycraft.plugin.data.responses.QueueInformation;
import net.buycraft.plugin.execution.strategy.ToRunQueuedCommand;

public class ImmediateCommandExecutor
implements Runnable {
    private final IBuycraftPlatform platform;

    public ImmediateCommandExecutor(IBuycraftPlatform platform) {
        this.platform = platform;
    }

    @Override
    public void run() {
        QueueInformation information;
        if (this.platform.getApiClient() == null) {
            return;
        }
        try {
            information = this.platform.getApiClient().retrieveOfflineQueue().execute().body();
        }
        catch (IOException e) {
            this.platform.log(Level.SEVERE, "Could not fetch command queue", e);
            return;
        }
        for (QueuedCommand command : information.getCommands()) {
            this.platform.getExecutor().queue(new ToRunQueuedCommand(command.getPlayer(), command, false));
        }
    }
}

