/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.execution;

import java.io.IOException;
import java.util.logging.Level;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.data.QueuedCommand;
import net.buycraft.plugin.data.QueuedPlayer;
import net.buycraft.plugin.data.responses.QueueInformation;
import net.buycraft.plugin.execution.strategy.ToRunQueuedCommand;

public class PlayerCommandExecutor
implements Runnable {
    private final QueuedPlayer player;
    private final IBuycraftPlatform platform;

    public PlayerCommandExecutor(QueuedPlayer player, IBuycraftPlatform platform) {
        this.player = player;
        this.platform = platform;
    }

    @Override
    public void run() {
        QueueInformation information;
        try {
            information = this.platform.getApiClient().getPlayerQueue(this.player.getId()).execute().body();
        }
        catch (IOException e) {
            this.platform.log(Level.SEVERE, "Could not fetch command queue for player", e);
            return;
        }
        this.platform.log(Level.INFO, String.format("Fetched %d commands for player '%s'.", information.getCommands().size(), this.player.getName()));
        for (QueuedCommand command : information.getCommands()) {
            this.platform.getExecutor().queue(new ToRunQueuedCommand(this.player, command, true));
        }
    }
}

