/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.execution;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.buycraft.plugin.BuyCraftAPIException;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.data.ServerEvent;

public class ServerEventSenderTask
implements Runnable {
    private final IBuycraftPlatform platform;
    private final boolean verbose;
    private final List<ServerEvent> eventQueue = Lists.newArrayList();

    public ServerEventSenderTask(IBuycraftPlatform platform, boolean verbose) {
        this.platform = platform;
        this.verbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.platform.getApiClient() == null) {
            return;
        }
        if (this.platform.getServerInformation() == null || !this.platform.getServerInformation().getAccount().isLogEvents()) {
            return;
        }
        while (this.eventQueue.size() > 0) {
            ArrayList runEvents = Lists.newArrayList(this.eventQueue.subList(0, Math.min(this.eventQueue.size(), 750)));
            try {
                if (this.verbose) {
                    this.platform.log(Level.INFO, "Sending " + runEvents.size() + " analytic events");
                }
                this.platform.getApiClient().sendEvents(runEvents).execute();
            }
            catch (IOException | BuyCraftAPIException e) {
                this.platform.log(Level.SEVERE, "Failed to send analytic events!", e);
                return;
            }
            List<ServerEvent> list = this.eventQueue;
            synchronized (list) {
                runEvents.forEach(this.eventQueue::remove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(ServerEvent event) {
        if (this.platform.getServerInformation() == null || !this.platform.getServerInformation().getAccount().isLogEvents()) {
            return;
        }
        List<ServerEvent> list = this.eventQueue;
        synchronized (list) {
            this.eventQueue.add(event);
        }
    }
}

