/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.execution.strategy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.execution.strategy.CommandExecutor;
import net.buycraft.plugin.execution.strategy.PostCompletedCommandsTask;
import net.buycraft.plugin.execution.strategy.ToRunQueuedCommand;
import net.buycraft.plugin.platform.NoBlocking;

public class QueuedCommandExecutor
implements CommandExecutor,
Runnable {
    private static final long MAXIMUM_NOTIFICATION_TIME = TimeUnit.MILLISECONDS.toNanos(5L);
    private final IBuycraftPlatform platform;
    private final boolean blocking;
    private final Set<ToRunQueuedCommand> commandQueue = new LinkedHashSet<ToRunQueuedCommand>();
    private final PostCompletedCommandsTask completedCommandsTask;
    private int runMaxCommandsBlocking = 10;

    public QueuedCommandExecutor(IBuycraftPlatform platform, PostCompletedCommandsTask completedCommandsTask) {
        this.platform = platform;
        this.blocking = !platform.getClass().isAnnotationPresent(NoBlocking.class);
        this.completedCommandsTask = completedCommandsTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue(ToRunQueuedCommand command) {
        Set<ToRunQueuedCommand> set = this.commandQueue;
        synchronized (set) {
            this.commandQueue.add(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<ToRunQueuedCommand> runThisTick = new ArrayList<ToRunQueuedCommand>();
        Set<ToRunQueuedCommand> set = this.commandQueue;
        synchronized (set) {
            ArrayList<Integer> queuedCommandIds = new ArrayList<Integer>();
            HashSet<ToRunQueuedCommand> removeSet = new HashSet<ToRunQueuedCommand>();
            for (ToRunQueuedCommand toRunQueuedCommand : this.commandQueue) {
                if (queuedCommandIds.contains(toRunQueuedCommand.getCommand().getId())) {
                    removeSet.add(toRunQueuedCommand);
                    continue;
                }
                queuedCommandIds.add(toRunQueuedCommand.getCommand().getId());
                if (toRunQueuedCommand.canExecute(this.platform)) {
                    runThisTick.add(toRunQueuedCommand);
                    removeSet.add(toRunQueuedCommand);
                }
                if (!this.blocking || runThisTick.size() < this.runMaxCommandsBlocking) continue;
                break;
            }
            this.commandQueue.removeAll(removeSet);
        }
        long start = System.nanoTime();
        for (ToRunQueuedCommand command : runThisTick) {
            if (this.completedCommandsTask.getRetained().contains(command.getCommand().getId())) {
                Set<ToRunQueuedCommand> set2 = this.commandQueue;
                synchronized (set2) {
                    this.commandQueue.remove(command);
                    continue;
                }
            }
            if (!command.canExecute(this.platform)) continue;
            String string = this.platform.getPlaceholderManager().doReplace(command.getPlayer(), command.getCommand());
            this.platform.log(Level.INFO, String.format("Dispatching command '%s' for player '%s'.", string, command.getPlayer().getName()));
            try {
                this.platform.dispatchCommand(string);
                this.completedCommandsTask.add(command.getCommand().getId());
            }
            catch (Exception e) {
                this.platform.log(Level.SEVERE, String.format("Could not dispatch command '%s' for player '%s'. This is typically a plugin error, not an issue with BuycraftX.", string, command.getPlayer().getName()), e);
            }
        }
        long fullTime = System.nanoTime() - start;
        if (fullTime > MAXIMUM_NOTIFICATION_TIME) {
            BigDecimal bigDecimal = new BigDecimal(fullTime).divide(new BigDecimal("1000000"), 2, 2);
            if (this.blocking) {
                this.platform.log(Level.SEVERE, "Command execution took " + bigDecimal.toPlainString() + "ms to complete. This likely indicates an issue with one of your server's plugins, which can cause lag.");
            } else {
                this.platform.log(Level.SEVERE, "Command execution took " + bigDecimal.toPlainString() + "ms to complete. This likely indicates an issue with one of your server's plugins, which will slow command execution.");
            }
        }
    }

    public void setRunMaxCommandsBlocking(int runMaxCommandsBlocking) {
        this.runMaxCommandsBlocking = runMaxCommandsBlocking;
    }
}

