/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.execution.strategy;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.data.QueuedCommand;
import net.buycraft.plugin.data.QueuedPlayer;

public final class ToRunQueuedCommand {
    private final QueuedPlayer player;
    private final QueuedCommand command;
    private final boolean requireOnline;
    private final long queueTime = System.currentTimeMillis();

    public ToRunQueuedCommand(QueuedPlayer player, QueuedCommand command, boolean requireOnline) {
        this.player = player;
        this.command = command;
        this.requireOnline = requireOnline;
    }

    public boolean canExecute(IBuycraftPlatform platform) {
        int free;
        Integer requiredSlots = this.command.getConditions().get("slots");
        if ((requiredSlots != null || this.requireOnline) && !platform.isPlayerOnline(this.player)) {
            return false;
        }
        if (requiredSlots != null && (free = platform.getFreeSlots(this.player)) < requiredSlots) {
            return false;
        }
        Integer delay = this.command.getConditions().get("delay");
        return delay == null || delay <= 0 || System.currentTimeMillis() - this.queueTime >= TimeUnit.SECONDS.toMillis(delay.intValue());
    }

    public QueuedPlayer getPlayer() {
        return this.player;
    }

    public QueuedCommand getCommand() {
        return this.command;
    }

    public boolean isRequireOnline() {
        return this.requireOnline;
    }

    public long getQueueTime() {
        return this.queueTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToRunQueuedCommand that = (ToRunQueuedCommand)o;
        if (this.requireOnline != that.requireOnline) {
            return false;
        }
        if (!Objects.equals(this.player, that.player)) {
            return false;
        }
        return Objects.equals(this.command, that.command);
    }

    public int hashCode() {
        int result = this.player != null ? this.player.hashCode() : 0;
        result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
        result = 31 * result + (this.requireOnline ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ToRunQueuedCommand(player=" + this.getPlayer() + ", command=" + this.getCommand() + ", requireOnline=" + this.isRequireOnline() + ", queueTime=" + this.getQueueTime() + ")";
    }
}

