/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.internal.retrofit2;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.annotation.Nullable;
import net.buycraft.plugin.internal.okhttp3.ResponseBody;
import net.buycraft.plugin.internal.retrofit2.Converter;
import net.buycraft.plugin.internal.retrofit2.Retrofit;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@IgnoreJRERequirement
final class OptionalConverterFactory
extends Converter.Factory {
    static final Converter.Factory INSTANCE = new OptionalConverterFactory();

    OptionalConverterFactory() {
    }

    @Override
    @Nullable
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (OptionalConverterFactory.getRawType(type) != Optional.class) {
            return null;
        }
        Type innerType = OptionalConverterFactory.getParameterUpperBound(0, (ParameterizedType)type);
        Converter delegate = retrofit.responseBodyConverter(innerType, annotations);
        return new OptionalConverter(delegate);
    }

    @IgnoreJRERequirement
    static final class OptionalConverter<T>
    implements Converter<ResponseBody, Optional<T>> {
        final Converter<ResponseBody, T> delegate;

        OptionalConverter(Converter<ResponseBody, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Optional<T> convert(ResponseBody value) throws IOException {
            return Optional.ofNullable(this.delegate.convert(value));
        }
    }
}

