/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.platform;

import java.util.Objects;
import net.buycraft.plugin.platform.PlatformType;
import org.jetbrains.annotations.NotNull;

public final class PlatformInformation {
    @NotNull
    private final PlatformType type;
    @NotNull
    private final String version;

    public PlatformInformation(@NotNull PlatformType type, @NotNull String version) {
        this.type = Objects.requireNonNull(type);
        this.version = Objects.requireNonNull(version);
    }

    @NotNull
    public PlatformType getType() {
        return this.type;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformInformation that = (PlatformInformation)o;
        if (this.type != that.type) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return "PlatformInformation(type=" + (Object)((Object)this.getType()) + ", version=" + this.getVersion() + ")";
    }
}

