/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.platform.standalone;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.buycraft.plugin.BuyCraftAPI;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.data.responses.ServerInformation;
import net.buycraft.plugin.execution.placeholder.NamePlaceholder;
import net.buycraft.plugin.execution.placeholder.PlaceholderManager;
import net.buycraft.plugin.execution.placeholder.UuidPlaceholder;
import net.buycraft.plugin.execution.strategy.CommandExecutor;
import net.buycraft.plugin.execution.strategy.PostCompletedCommandsTask;
import net.buycraft.plugin.execution.strategy.QueuedCommandExecutor;
import net.buycraft.plugin.platform.PlatformInformation;
import net.buycraft.plugin.platform.PlatformType;

public abstract class StandaloneBuycraftPlatform
implements IBuycraftPlatform {
    private final BuyCraftAPI client;
    private final PlaceholderManager placeholderManager = new PlaceholderManager();
    private final QueuedCommandExecutor commandExecutor;
    private final ScheduledExecutorService scheduler;

    protected StandaloneBuycraftPlatform(BuyCraftAPI client) {
        this(client, Executors.newScheduledThreadPool(8));
    }

    protected StandaloneBuycraftPlatform(BuyCraftAPI client, ScheduledExecutorService executorService) {
        this.client = client;
        this.scheduler = executorService;
        this.placeholderManager.addPlaceholder(new NamePlaceholder());
        this.placeholderManager.addPlaceholder(new UuidPlaceholder());
        PostCompletedCommandsTask completedCommandsTask = new PostCompletedCommandsTask(this);
        this.commandExecutor = new QueuedCommandExecutor(this, completedCommandsTask);
        this.scheduler.scheduleAtFixedRate(this.commandExecutor, 50L, 50L, TimeUnit.MILLISECONDS);
        this.scheduler.scheduleAtFixedRate(completedCommandsTask, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public BuyCraftAPI getApiClient() {
        return this.client;
    }

    @Override
    public PlaceholderManager getPlaceholderManager() {
        return this.placeholderManager;
    }

    @Override
    public void executeAsync(Runnable runnable) {
        this.scheduler.execute(runnable);
    }

    @Override
    public void executeAsyncLater(Runnable runnable, long time, TimeUnit unit) {
        this.scheduler.schedule(runnable, time, unit);
    }

    @Override
    public void executeBlocking(Runnable runnable) {
        this.scheduler.execute(runnable);
    }

    @Override
    public void executeBlockingLater(Runnable runnable, long time, TimeUnit unit) {
        this.scheduler.schedule(runnable, time, unit);
    }

    @Override
    public CommandExecutor getExecutor() {
        return this.commandExecutor;
    }

    @Override
    public PlatformInformation getPlatformInformation() {
        return new PlatformInformation(PlatformType.NONE, "");
    }

    @Override
    public String getPluginVersion() {
        return "";
    }

    @Override
    public ServerInformation getServerInformation() {
        return null;
    }
}

