/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.platform.standalone.runner;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.buycraft.plugin.BuyCraftAPI;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.data.QueuedPlayer;
import net.buycraft.plugin.data.responses.ServerInformation;
import net.buycraft.plugin.execution.DuePlayerFetcher;
import net.buycraft.plugin.internal.okhttp3.OkHttpClient;
import net.buycraft.plugin.platform.NoBlocking;
import net.buycraft.plugin.platform.standalone.StandaloneBuycraftPlatform;
import net.buycraft.plugin.platform.standalone.runner.CommandDispatcher;
import net.buycraft.plugin.platform.standalone.runner.PlayerDeterminer;

public class StandaloneBuycraftRunner {
    private final CommandDispatcher dispatcher;
    private final PlayerDeterminer determiner;
    private final String apiKey;
    private final Logger logger;
    private final ScheduledExecutorService executorService;
    private final IBuycraftPlatform platform;
    private final boolean verbose;
    private ServerInformation serverInformation;
    private DuePlayerFetcher playerFetcher;

    StandaloneBuycraftRunner(CommandDispatcher dispatcher, PlayerDeterminer determiner, String apiKey, Logger logger, ScheduledExecutorService executorService, boolean verbose) {
        this.dispatcher = dispatcher;
        this.determiner = determiner;
        this.apiKey = apiKey;
        this.logger = logger;
        this.executorService = executorService;
        this.platform = new Platform();
        this.verbose = verbose;
    }

    public void initializeTasks() {
        try {
            this.serverInformation = this.platform.getApiClient().getServerInformation().execute().body();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't fetch account information", e);
        }
        this.playerFetcher = new DuePlayerFetcher(this.platform, this.verbose);
        this.executorService.schedule(this.playerFetcher, 1L, TimeUnit.SECONDS);
    }

    public ServerInformation getServerInformation() {
        return this.serverInformation;
    }

    public DuePlayerFetcher getPlayerFetcher() {
        return this.playerFetcher;
    }

    @NoBlocking
    private class Platform
    extends StandaloneBuycraftPlatform {
        Platform() {
            super(BuyCraftAPI.create(StandaloneBuycraftRunner.this.apiKey, new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).build()), StandaloneBuycraftRunner.this.executorService);
        }

        @Override
        public void dispatchCommand(String command) {
            StandaloneBuycraftRunner.this.dispatcher.dispatchCommand(command);
        }

        @Override
        public boolean isPlayerOnline(QueuedPlayer player) {
            return StandaloneBuycraftRunner.this.determiner.isPlayerOnline(player);
        }

        @Override
        public int getFreeSlots(QueuedPlayer player) {
            return StandaloneBuycraftRunner.this.determiner.getFreeSlots(player);
        }

        @Override
        public void log(Level level, String message) {
            StandaloneBuycraftRunner.this.logger.log(level, message);
        }

        @Override
        public void log(Level level, String message, Throwable throwable) {
            StandaloneBuycraftRunner.this.logger.log(level, message, throwable);
        }

        @Override
        public ServerInformation getServerInformation() {
            return StandaloneBuycraftRunner.this.serverInformation;
        }
    }
}

