/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.platform.standalone.runner;

import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import net.buycraft.plugin.platform.standalone.runner.CommandDispatcher;
import net.buycraft.plugin.platform.standalone.runner.PlayerDeterminer;
import net.buycraft.plugin.platform.standalone.runner.StandaloneBuycraftRunner;
import org.jetbrains.annotations.NotNull;

public class StandaloneBuycraftRunnerBuilder {
    @NotNull
    private final CommandDispatcher dispatcher;
    @NotNull
    private final PlayerDeterminer determiner;
    @NotNull
    private final String apiKey;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private boolean verbose;

    StandaloneBuycraftRunnerBuilder(@NotNull CommandDispatcher dispatcher, @NotNull PlayerDeterminer determiner, @NotNull String apiKey, @NotNull Logger logger, @NotNull ScheduledExecutorService executorService, @NotNull boolean verbose) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.determiner = Objects.requireNonNull(determiner);
        this.apiKey = Objects.requireNonNull(apiKey);
        this.logger = Objects.requireNonNull(logger);
        this.executorService = Objects.requireNonNull(executorService);
        this.verbose = verbose;
    }

    public static StandaloneBuycraftRunnerBuilderBuilder builder() {
        return new StandaloneBuycraftRunnerBuilderBuilder();
    }

    public StandaloneBuycraftRunner start() {
        StandaloneBuycraftRunner runner = new StandaloneBuycraftRunner(this.dispatcher, this.determiner, this.apiKey, this.logger, this.executorService, this.verbose);
        runner.initializeTasks();
        return runner;
    }

    public static class StandaloneBuycraftRunnerBuilderBuilder {
        private CommandDispatcher dispatcher;
        private PlayerDeterminer determiner;
        private String apiKey;
        private Logger logger;
        private ScheduledExecutorService executorService;
        private boolean verbose;

        StandaloneBuycraftRunnerBuilderBuilder() {
        }

        public StandaloneBuycraftRunnerBuilderBuilder dispatcher(@NotNull CommandDispatcher dispatcher) {
            this.dispatcher = Objects.requireNonNull(dispatcher);
            return this;
        }

        public StandaloneBuycraftRunnerBuilderBuilder determiner(@NotNull PlayerDeterminer determiner) {
            this.determiner = Objects.requireNonNull(determiner);
            return this;
        }

        public StandaloneBuycraftRunnerBuilderBuilder apiKey(@NotNull String apiKey) {
            this.apiKey = Objects.requireNonNull(apiKey);
            return this;
        }

        public StandaloneBuycraftRunnerBuilderBuilder logger(@NotNull Logger logger) {
            this.logger = Objects.requireNonNull(logger);
            return this;
        }

        public StandaloneBuycraftRunnerBuilderBuilder executorService(@NotNull ScheduledExecutorService executorService) {
            this.executorService = Objects.requireNonNull(executorService);
            return this;
        }

        public StandaloneBuycraftRunnerBuilderBuilder verbose(@NotNull boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public StandaloneBuycraftRunnerBuilder build() {
            return new StandaloneBuycraftRunnerBuilder(this.dispatcher, this.determiner, this.apiKey, this.logger, this.executorService, this.verbose);
        }

        public String toString() {
            return "StandaloneBuycraftRunnerBuilder.StandaloneBuycraftRunnerBuilderBuilder(dispatcher=" + this.dispatcher + ", determiner=" + this.determiner + ", apiKey=" + this.apiKey + ", logger=" + this.logger + ", executorService=" + this.executorService + ", verbose=" + this.verbose + ")";
        }
    }
}

