/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.shared.config;

import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class BuycraftI18n {
    private ResourceBundle bundle;
    private ResourceBundle userBundle;

    public BuycraftI18n(Locale locale) {
        try {
            this.bundle = ResourceBundle.getBundle("buycraftx_messages", locale, BuycraftI18n.class.getClassLoader());
        }
        catch (Exception e) {
            new RuntimeException("Failed to load i18n files! Will be using message ids as a replacement", e).printStackTrace();
        }
    }

    public void loadUserBundle(Path resource) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(resource, StandardCharsets.UTF_8);){
            this.userBundle = new PropertyResourceBundle(reader);
        }
    }

    public String get(String message, Object ... params) {
        try {
            return MessageFormat.format(this.getBundleFor(message).getString(message), params);
        }
        catch (Exception e) {
            return "i18n:" + message + "(" + Joiner.on((String)", ").join(params) + ")";
        }
    }

    public ResourceBundle getBundleFor(String message) {
        return this.userBundle != null && this.userBundle.containsKey(message) ? this.userBundle : this.bundle;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public ResourceBundle getUserBundle() {
        return this.userBundle;
    }
}

