/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.shared.config.signs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import net.buycraft.plugin.data.Package;

public class BuyNowSignLayout {
    public static final BuyNowSignLayout DEFAULT = new BuyNowSignLayout((List<String>)ImmutableList.of((Object)"&9[Package]", (Object)"%name%", (Object)"%price%"));
    private final List<String> lines;

    public BuyNowSignLayout(List<String> lines) {
        this.lines = ImmutableList.copyOf(lines);
    }

    public List<String> format(Currency currency, Package p) {
        NumberFormat format = NumberFormat.getCurrencyInstance(Locale.US);
        format.setCurrency(currency);
        ArrayList<String> formatted = new ArrayList<String>();
        for (String line : this.lines) {
            formatted.add(line.replace("%name%", BuyNowSignLayout.abbreviate(p.getName(), 16)).replace("%price%", format.format(p.getEffectivePrice())));
        }
        return formatted;
    }

    private static String abbreviate(String string, int maximumLength) {
        Preconditions.checkNotNull((Object)string, (Object)"string");
        Preconditions.checkArgument((maximumLength > 0 ? 1 : 0) != 0, (String)"length to trim to (%s) is not valid (greater than 0)", (Object[])new Object[]{maximumLength});
        return string.length() > maximumLength ? string.substring(0, maximumLength - 3) + "..." : string;
    }
}

