/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.shared.config.signs;

import com.google.common.collect.ImmutableList;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import net.buycraft.plugin.data.RecentPayment;

public class RecentPurchaseSignLayout {
    public static final RecentPurchaseSignLayout DEFAULT = new RecentPurchaseSignLayout((List<String>)ImmutableList.of((Object)"", (Object)"%player%", (Object)"%amount%"));
    private final List<String> lines;

    public RecentPurchaseSignLayout(List<String> lines) {
        this.lines = ImmutableList.copyOf(lines);
    }

    public List<String> format(RecentPayment p) {
        NumberFormat format = NumberFormat.getCurrencyInstance(Locale.US);
        format.setCurrency(Currency.getInstance(p.getCurrency().getIso4217()));
        ArrayList<String> formatted = new ArrayList<String>();
        for (String line : this.lines) {
            formatted.add(line.replace("%player%", p.getPlayer().getName()).replace("%amount%", format.format(p.getAmount())));
        }
        return formatted;
    }
}

