/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.shared.config.signs.storage;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.buycraft.plugin.shared.config.signs.storage.RecentPurchaseSignPosition;
import net.buycraft.plugin.shared.config.signs.storage.SerializedBlockLocation;

public class RecentPurchaseSignStorage {
    private final List<RecentPurchaseSignPosition> signs = new ArrayList<RecentPurchaseSignPosition>();
    private final transient Gson gson = new Gson();

    public void addSign(RecentPurchaseSignPosition location) {
        this.signs.add(location);
    }

    public boolean removeSign(RecentPurchaseSignPosition location) {
        return this.signs.remove(location);
    }

    public boolean removeSign(SerializedBlockLocation location) {
        Iterator<RecentPurchaseSignPosition> it = this.signs.iterator();
        while (it.hasNext()) {
            RecentPurchaseSignPosition psp = it.next();
            if (!psp.getLocation().equals(location)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public List<RecentPurchaseSignPosition> getSigns() {
        return ImmutableList.copyOf(this.signs);
    }

    public boolean containsLocation(SerializedBlockLocation location) {
        for (RecentPurchaseSignPosition sign : this.signs) {
            if (!sign.getLocation().equals(location)) continue;
            return true;
        }
        return false;
    }

    public void load(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                RecentPurchaseSignStorage s = (RecentPurchaseSignStorage)this.gson.fromJson((Reader)reader, RecentPurchaseSignStorage.class);
                if (s != null) {
                    this.signs.addAll(s.signs);
                }
            }
        }
    }

    public void save(Path path) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.gson.toJson((Object)this, (Appendable)writer);
        }
    }
}

