/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.shared.util;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.buycraft.plugin.IBuycraftPlatform;
import net.buycraft.plugin.internal.okhttp3.MediaType;
import net.buycraft.plugin.internal.okhttp3.OkHttpClient;
import net.buycraft.plugin.internal.okhttp3.Request;
import net.buycraft.plugin.internal.okhttp3.RequestBody;
import net.buycraft.plugin.internal.okhttp3.Response;
import net.buycraft.plugin.internal.okhttp3.ResponseBody;

public final class AnalyticsSend {
    private AnalyticsSend() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void sendAnalytics(OkHttpClient client, String secret, Map<String, Object> info) throws IOException {
        Response response = client.newCall(new Request.Builder().url("https://plugin.buycraft.net/analytics/startup").post(RequestBody.create(MediaType.parse("application/json"), new Gson().toJson(info))).header("X-Buycraft-Secret", secret).build()).execute();
        try (ResponseBody body = response.body();){
            if (response.code() != 201) {
                throw new IOException("Error whilst sending analytics (" + response.code() + "): " + body.string());
            }
        }
    }

    public static void postServerInformation(OkHttpClient client, String serverKey, IBuycraftPlatform platform, boolean onlineMode) throws IOException {
        LinkedHashMap<String, Object> serverData = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> pluginData = new LinkedHashMap<String, String>();
        serverData.put("platform", platform.getPlatformInformation().getType().platformName());
        serverData.put("platform_version", platform.getPlatformInformation().getVersion());
        serverData.put("online_mode", onlineMode);
        pluginData.put("version", platform.getPluginVersion());
        LinkedHashMap<String, Object> keenData = new LinkedHashMap<String, Object>();
        keenData.put("server", serverData);
        keenData.put("plugin", pluginData);
        AnalyticsSend.sendAnalytics(client, serverKey, keenData);
    }
}

