/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.shared.util;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import net.buycraft.plugin.data.responses.Version;
import net.buycraft.plugin.internal.okhttp3.OkHttpClient;
import net.buycraft.plugin.internal.okhttp3.Request;
import net.buycraft.plugin.internal.okhttp3.Response;
import net.buycraft.plugin.internal.okhttp3.ResponseBody;

public final class VersionUtil {
    private VersionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Version getVersion(OkHttpClient client, String platform, String secret) throws IOException {
        Request request = new Request.Builder().url("https://plugin.buycraft.net/versions/" + platform).addHeader("X-Buycraft-Secret", secret).build();
        Response response = client.newCall(request).execute();
        if (!response.isSuccessful()) {
            response.body().close();
            return null;
        }
        try (ResponseBody body = response.body();){
            Version version = (Version)new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create().fromJson(body.string(), Version.class);
            return version;
        }
    }

    public static boolean isVersionGreater(String one, String two) {
        int i;
        String[] componentsOne = one.split("\\.");
        String[] componentsTwo = two.split("\\.");
        int verLen = Math.min(componentsOne.length, componentsTwo.length);
        int[] numOne = new int[verLen];
        int[] numTwo = new int[verLen];
        for (i = 0; i < verLen; ++i) {
            numOne[i] = Integer.parseInt(componentsOne[i]);
        }
        for (i = 0; i < verLen; ++i) {
            numTwo[i] = Integer.parseInt(componentsTwo[i]);
        }
        for (i = 0; i < verLen; ++i) {
            if (numTwo[i] == numOne[i]) continue;
            return numTwo[i] > numOne[i];
        }
        return false;
    }
}

