/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge;

import java.util.Date;
import net.buycraft.plugin.data.QueuedPlayer;
import net.buycraft.plugin.data.ServerEvent;
import net.buycraft.plugin.sponge.BuycraftPlugin;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.network.ClientConnectionEvent;

public class BuycraftListener {
    private final BuycraftPlugin plugin;

    public BuycraftListener(BuycraftPlugin plugin) {
        this.plugin = plugin;
    }

    @Listener
    public void onPlayerJoinEvent(ClientConnectionEvent.Join event) {
        if (this.plugin.getApiClient() == null) {
            return;
        }
        this.plugin.getServerEventSenderTask().queueEvent(new ServerEvent(event.getTargetEntity().getUniqueId().toString().replace("-", ""), event.getTargetEntity().getName(), event.getTargetEntity().getConnection().getAddress().getAddress().getHostAddress(), "server.join", new Date()));
        QueuedPlayer qp = this.plugin.getDuePlayerFetcher().fetchAndRemoveDuePlayer(event.getTargetEntity().getName());
        if (qp != null) {
            this.plugin.getPlayerJoinCheckTask().queue(qp);
        }
    }

    @Listener
    public void onPlayerQuitEvent(ClientConnectionEvent.Disconnect event) {
        if (this.plugin.getApiClient() == null) {
            return;
        }
        this.plugin.getServerEventSenderTask().queueEvent(new ServerEvent(event.getTargetEntity().getUniqueId().toString().replace("-", ""), event.getTargetEntity().getName(), event.getTargetEntity().getConnection().getAddress().getAddress().getHostAddress(), "server.leave", new Date()));
    }
}

