/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge.command;

import java.io.IOException;
import net.buycraft.plugin.BuyCraftAPI;
import net.buycraft.plugin.data.responses.ServerInformation;
import net.buycraft.plugin.sponge.BuycraftPlugin;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class SecretCmd
implements CommandExecutor {
    private final BuycraftPlugin plugin;

    public SecretCmd(BuycraftPlugin plugin) {
        this.plugin = plugin;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof ConsoleSource)) {
            src.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("secret_console_only", new Object[0])).color(TextColors.RED).build());
        } else if (!args.getOne("secret").isPresent()) {
            src.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("secret_need_key", new Object[0])).color(TextColors.RED).build());
        } else {
            this.plugin.getPlatform().executeAsync(() -> {
                String currentKey = this.plugin.getConfiguration().getServerKey();
                BuyCraftAPI client = BuyCraftAPI.create((String)args.getOne("secret").get(), this.plugin.getHttpClient());
                try {
                    this.plugin.updateInformation(client);
                }
                catch (IOException e) {
                    this.plugin.getLogger().error("Unable to verify secret", (Throwable)e);
                    src.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("secret_does_not_work", new Object[0])).color(TextColors.RED).build());
                    return;
                }
                ServerInformation information = this.plugin.getServerInformation();
                this.plugin.setApiClient(client);
                this.plugin.getListingUpdateTask().run();
                this.plugin.getConfiguration().setServerKey((String)args.getOne("secret").get());
                try {
                    this.plugin.saveConfiguration();
                }
                catch (IOException e) {
                    src.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("secret_cant_be_saved", new Object[0])).color(TextColors.RED).build());
                }
                src.sendMessage((Text)Text.builder((String)this.plugin.getI18n().get("secret_success", information.getServer().getName(), information.getAccount().getName())).color(TextColors.GREEN).build());
                boolean repeatChecks = false;
                if (currentKey.equals("INVALID")) {
                    repeatChecks = true;
                }
                this.plugin.getDuePlayerFetcher().run(repeatChecks);
            });
        }
        return CommandResult.success();
    }
}

