/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge.signs.buynow;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.buycraft.plugin.shared.config.signs.storage.SavedBuyNowSign;
import net.buycraft.plugin.shared.config.signs.storage.SerializedBlockLocation;
import net.buycraft.plugin.sponge.BuycraftPlugin;
import net.buycraft.plugin.sponge.tasks.BuyNowSignUpdater;
import net.buycraft.plugin.sponge.tasks.SendCheckoutLinkTask;
import net.buycraft.plugin.sponge.util.SpongeSerializedBlockLocation;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.tileentity.ChangeSignEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class BuyNowSignListener {
    private static final long COOLDOWN_MS = 250L;
    private final BuycraftPlugin plugin;
    private final Map<UUID, Long> signCooldowns = new HashMap<UUID, Long>();

    public BuyNowSignListener(BuycraftPlugin plugin) {
        this.plugin = plugin;
    }

    @Listener
    public void onSignChange(ChangeSignEvent event) {
        int pos;
        boolean ourSign;
        try {
            ourSign = ((Text)event.getOriginalText().lines().get(0)).toPlain().equalsIgnoreCase("[buycraft_buy]");
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        if (!ourSign) {
            return;
        }
        Optional pl = event.getCause().first(Player.class);
        if (!pl.isPresent()) {
            return;
        }
        Player player = (Player)pl.get();
        if (!player.hasPermission("buycraft.admin")) {
            ((Player)event.getCause().first(Player.class).get()).sendMessage((Text)Text.builder((String)"You can't create Buycraft signs.").color(TextColors.RED).build());
            return;
        }
        try {
            pos = Integer.parseInt(((Text)event.getOriginalText().lines().get(1)).toPlain());
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            ((Player)event.getCause().first(Player.class).get()).sendMessage((Text)Text.builder((String)"The second line must be a number.").color(TextColors.RED).build());
            return;
        }
        this.plugin.getBuyNowSignStorage().addSign(new SavedBuyNowSign(SpongeSerializedBlockLocation.create((Location<World>)event.getTargetTile().getLocation()), pos));
        player.sendMessage((Text)Text.builder((String)"Added new buy now sign!").color(TextColors.GREEN).build());
        SignData signData = event.getText();
        ListValue lines = signData.lines();
        for (int i = 0; i < 4; ++i) {
            if (i == 0) {
                lines.set(i, (Object)Text.builder((String)"Buy!").build());
                continue;
            }
            lines.set(i, (Object)Text.EMPTY);
        }
        signData.set((BaseValue)lines);
        this.plugin.getPlatform().executeAsync(new BuyNowSignUpdater(this.plugin));
    }

    private boolean isSign(Location<World> sign) {
        return sign.getBlockType().equals(BlockTypes.WALL_SIGN) || sign.getBlockType().equals(BlockTypes.STANDING_SIGN);
    }

    private boolean removeSign(Player player, SerializedBlockLocation location) {
        if (this.plugin.getBuyNowSignStorage().containsLocation(location)) {
            if (!player.hasPermission("buycraft.admin")) {
                player.sendMessage((Text)Text.builder((String)"You don't have permission to break this sign.").color(TextColors.RED).build());
                return false;
            }
            if (this.plugin.getBuyNowSignStorage().removeSign(location)) {
                player.sendMessage((Text)Text.builder((String)"Removed buy now sign!").color(TextColors.RED).build());
                return true;
            }
            player.sendMessage((Text)Text.builder((String)"Unable to remove buy now sign!").color(TextColors.RED).build());
            return false;
        }
        return true;
    }

    @Listener
    public void onBlockBreak(ChangeBlockEvent.Break event) {
        event.getTransactions().forEach(trans -> {
            if (((BlockSnapshot)trans.getOriginal()).getState().getType().equals(BlockTypes.WALL_SIGN) || ((BlockSnapshot)trans.getOriginal()).getState().getType().equals(BlockTypes.STANDING_SIGN)) {
                Optional locationOptional = ((BlockSnapshot)trans.getOriginal()).getLocation();
                Optional playerOptional = event.getCause().first(Player.class);
                if (!this.removeSign((Player)playerOptional.get(), SpongeSerializedBlockLocation.create((Location<World>)((Location)locationOptional.get())))) {
                    event.setCancelled(true);
                }
            }
        });
    }

    @Listener
    public void onRightClickBlock(InteractBlockEvent.Secondary event) {
        BlockSnapshot b = event.getTargetBlock();
        if (!b.getState().getType().equals(BlockTypes.WALL_SIGN) && !b.getState().getType().equals(BlockTypes.STANDING_SIGN)) {
            return;
        }
        Player p = (Player)event.getCause().first(Player.class).get();
        SerializedBlockLocation sbl = SpongeSerializedBlockLocation.create((Location<World>)((Location)b.getLocation().get()));
        for (SavedBuyNowSign s : this.plugin.getBuyNowSignStorage().getSigns()) {
            if (!s.getLocation().equals(sbl)) continue;
            Long ts = this.signCooldowns.get(p.getUniqueId());
            long now = System.currentTimeMillis();
            if (ts == null || ts + 250L <= now) {
                this.signCooldowns.put(p.getUniqueId(), now);
                this.plugin.getPlatform().executeAsync(new SendCheckoutLinkTask(this.plugin, s.getPackageId(), p));
            }
            return;
        }
    }
}

