/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge.signs.purchases;

import java.util.Optional;
import net.buycraft.plugin.shared.config.signs.storage.RecentPurchaseSignPosition;
import net.buycraft.plugin.shared.config.signs.storage.SerializedBlockLocation;
import net.buycraft.plugin.sponge.BuycraftPlugin;
import net.buycraft.plugin.sponge.tasks.SignUpdater;
import net.buycraft.plugin.sponge.util.SpongeSerializedBlockLocation;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.tileentity.ChangeSignEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class RecentPurchaseSignListener {
    private final BuycraftPlugin plugin;

    public RecentPurchaseSignListener(BuycraftPlugin plugin) {
        this.plugin = plugin;
    }

    @Listener
    public void onSignChange(ChangeSignEvent event) {
        int pos;
        boolean ourSign;
        try {
            ourSign = ((Text)event.getOriginalText().lines().get(0)).toPlain().equalsIgnoreCase("[buycraft_rp]");
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        if (!ourSign) {
            return;
        }
        Optional pl = event.getCause().first(Player.class);
        if (!pl.isPresent()) {
            return;
        }
        Player player = (Player)pl.get();
        if (!player.hasPermission("buycraft.admin")) {
            ((Player)event.getCause().first(Player.class).get()).sendMessage((Text)Text.builder((String)"You can't create Buycraft signs.").color(TextColors.RED).build());
            return;
        }
        try {
            pos = Integer.parseInt(((Text)event.getOriginalText().lines().get(1)).toPlain());
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            ((Player)event.getCause().first(Player.class).get()).sendMessage((Text)Text.builder((String)"The second line must be a number.").color(TextColors.RED).build());
            return;
        }
        if (pos <= 0) {
            player.sendMessage((Text)Text.builder((String)"You can't show negative or zero purchases!").color(TextColors.RED).build());
            return;
        }
        if (pos > 100) {
            player.sendMessage((Text)Text.builder((String)"You can't show more than 100 recent purchases!").color(TextColors.RED).build());
            return;
        }
        this.plugin.getRecentPurchaseSignStorage().addSign(new RecentPurchaseSignPosition(SpongeSerializedBlockLocation.create((Location<World>)event.getTargetTile().getLocation()), pos));
        player.sendMessage((Text)Text.builder((String)"Added new recent purchase sign!").color(TextColors.GREEN).build());
        SignData signData = event.getText();
        ListValue lines = signData.lines();
        for (int i = 0; i < 4; ++i) {
            lines.set(i, (Object)Text.EMPTY);
        }
        signData.set((BaseValue)lines);
        this.plugin.getPlatform().executeAsync(new SignUpdater(this.plugin));
    }

    private boolean isSign(Location<World> sign) {
        return sign.getBlockType().equals(BlockTypes.WALL_SIGN) || sign.getBlockType().equals(BlockTypes.STANDING_SIGN);
    }

    private boolean removeSign(Player player, SerializedBlockLocation location) {
        if (this.plugin.getRecentPurchaseSignStorage().containsLocation(location)) {
            if (!player.hasPermission("buycraft.admin")) {
                player.sendMessage((Text)Text.builder((String)"You don't have permission to break this sign.").color(TextColors.RED).build());
                return false;
            }
            if (this.plugin.getRecentPurchaseSignStorage().removeSign(location)) {
                player.sendMessage((Text)Text.builder((String)"Removed recent purchase sign!").color(TextColors.RED).build());
                return true;
            }
        }
        return true;
    }

    @Listener
    public void onBlockBreak(ChangeBlockEvent.Break event) {
        event.getTransactions().forEach(trans -> {
            if (((BlockSnapshot)trans.getOriginal()).getState().getType().equals(BlockTypes.WALL_SIGN) || ((BlockSnapshot)trans.getOriginal()).getState().getType().equals(BlockTypes.STANDING_SIGN)) {
                Optional locationOptional = ((BlockSnapshot)trans.getOriginal()).getLocation();
                Optional playerOptional = event.getCause().first(Player.class);
                if (!this.removeSign((Player)playerOptional.get(), SpongeSerializedBlockLocation.create((Location<World>)((Location)locationOptional.get())))) {
                    event.setCancelled(true);
                }
            }
        });
    }
}

