/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.plugin.sponge.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import net.buycraft.plugin.data.responses.Version;
import net.buycraft.plugin.shared.util.VersionUtil;
import net.buycraft.plugin.sponge.BuycraftPlugin;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

public class VersionCheck {
    private final BuycraftPlugin plugin;
    private final String pluginVersion;
    private final String secret;
    private Version lastKnownVersion;
    private boolean upToDate = true;

    public VersionCheck(BuycraftPlugin plugin, String pluginVersion, String secret) {
        this.plugin = plugin;
        this.pluginVersion = pluginVersion;
        this.secret = secret;
    }

    public void verify() throws IOException {
        if (this.pluginVersion.endsWith("-SNAPSHOT")) {
            return;
        }
        this.lastKnownVersion = VersionUtil.getVersion(this.plugin.getHttpClient(), "sponge", this.secret);
        if (this.lastKnownVersion == null) {
            return;
        }
        String latestVersionString = this.lastKnownVersion.getVersion();
        if (!latestVersionString.equals(this.pluginVersion)) {
            boolean bl = this.upToDate = !VersionUtil.isVersionGreater(this.pluginVersion, latestVersionString);
            if (!this.upToDate) {
                this.plugin.getLogger().info(this.plugin.getI18n().get("update_available", this.lastKnownVersion.getVersion()));
            }
        }
    }

    @Listener
    public void onPlayerJoinEvent(ClientConnectionEvent.Join event) {
        if (event.getTargetEntity().hasPermission("buycraft.admin") && !this.upToDate) {
            this.plugin.getPlatform().executeAsyncLater(() -> {
                try {
                    event.getTargetEntity().sendMessage(Text.builder().append(new Text[]{Text.of((String)this.plugin.getI18n().get("update_available", this.lastKnownVersion.getVersion()))}).onClick((ClickAction)TextActions.openUrl((URL)new URL("https://server.tebex.io"))).color(TextColors.YELLOW).build());
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
            }, 3L, TimeUnit.SECONDS);
        }
    }

    public Version getLastKnownVersion() {
        return this.lastKnownVersion;
    }

    public boolean isUpToDate() {
        return this.upToDate;
    }
}

