/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building;

import java.util.List;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.BlockFlower;
import knightminer.inspirations.building.block.BlockRope;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.Util;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class BuildingEvents {
    @SubscribeEvent
    public static void addFlowerDrop(BlockEvent.HarvestDropsEvent event) {
        if (!Config.enableFlowers || event.isCanceled() || event.getWorld().field_72995_K) {
            return;
        }
        IBlockState state = event.getState();
        if (state.func_177230_c() != Blocks.field_150398_cm) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (player == null || player.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack shears = player.func_184614_ca();
        Item item = shears.func_77973_b();
        if (!(item instanceof ItemShears) && !item.getToolClasses(shears).contains("shears")) {
            return;
        }
        BlockFlower.FlowerType type = BlockFlower.FlowerType.fromDouble((BlockDoublePlant.EnumPlantType)state.func_185899_b((IBlockAccess)event.getWorld(), event.getPos()).func_177229_b((IProperty)BlockDoublePlant.field_176493_a));
        if (type == null) {
            return;
        }
        List drops = event.getDrops();
        Item doublePlant = Item.func_150898_a((Block)Blocks.field_150398_cm);
        for (ItemStack drop : drops) {
            if (drop.func_77973_b() != doublePlant) continue;
            drops.remove(drop);
            drops.add(new ItemStack(InspirationsBuilding.flower, 2, type.getMeta()));
            break;
        }
    }

    @SubscribeEvent
    public static void toggleRopeLadder(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (!Config.enableRopeLadder) {
            return;
        }
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(pos = event.getPos());
        if (state.func_177230_c() != InspirationsBuilding.rope) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (state.func_177229_b(BlockRope.RUNGS) != BlockRope.Rungs.NONE) {
            if (BuildingEvents.removeRopeLadder(world, pos, state, player)) {
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
            }
            return;
        }
        if (BuildingEvents.makeRopeLadder(world, pos, state, event.getFace(), player, event.getItemStack())) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    private static boolean removeRopeLadder(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.func_70093_af()) {
            return false;
        }
        world.func_175656_a(pos, state.func_177226_a(BlockRope.RUNGS, (Comparable)((Object)BlockRope.Rungs.NONE)));
        SoundType soundtype = state.func_177230_c().getSoundType(state, world, pos, (Entity)player);
        world.func_184133_a(player, pos, soundtype.func_185845_c(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(((BlockRope.RopeType)((Object)state.func_177229_b(BlockRope.TYPE))).getItem(), 4), (int)player.field_71071_by.field_70461_c);
        return true;
    }

    private static boolean makeRopeLadder(World world, BlockPos pos, IBlockState state, EnumFacing side, EntityPlayer player, ItemStack stack) {
        if (side.func_176740_k() == EnumFacing.Axis.Y || stack.func_190916_E() < 4 && !player.func_184812_l_()) {
            return false;
        }
        BlockRope.RopeType type = (BlockRope.RopeType)((Object)state.func_177229_b(BlockRope.TYPE));
        if (type == BlockRope.RopeType.CHAIN ? !Util.oreMatches(stack, "nuggetIron") : stack.func_77973_b() != Items.field_151055_y) {
            return false;
        }
        world.func_175656_a(pos, state.func_177226_a(BlockRope.RUNGS, (Comparable)((Object)BlockRope.Rungs.fromAxis(side.func_176746_e().func_176740_k()))));
        SoundType soundtype = state.func_177230_c().getSoundType(state, world, pos, (Entity)player);
        world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(4);
        }
        return true;
    }
}

