/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common;

import javax.annotation.Nonnull;
import knightminer.inspirations.common.CommonProxy;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.shared.client.TextureModel;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.item.ItemEdible;
import slimeknights.mantle.item.ItemMetaDynamic;

public class ClientProxy
extends CommonProxy {
    public static final String VARIANT_INVENTORY = "inventory";

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected static ResourceLocation registerItemModel(Block block) {
        return ClientProxy.registerItemModel(Item.func_150898_a((Block)block));
    }

    protected static ResourceLocation registerItemModel(Item item) {
        ResourceLocation itemLocation = null;
        if (item != null) {
            itemLocation = item.getRegistryName();
        }
        if (itemLocation != null) {
            itemLocation = ClientProxy.registerItemModel(item, itemLocation);
        }
        return itemLocation;
    }

    protected static ResourceLocation registerItemModel(Item item, final ResourceLocation location) {
        if (item == null || location == null) {
            return location;
        }
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            @Nonnull
            public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                return new ModelResourceLocation(location, ClientProxy.VARIANT_INVENTORY);
            }
        });
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        return location;
    }

    public static void registerItemModel(Item item, int meta) {
        ClientProxy.registerItemModel(item, meta, VARIANT_INVENTORY);
    }

    public static void registerItemModel(Block block, int meta, String variant) {
        if (block != null) {
            ClientProxy.registerItemModel(Item.func_150898_a((Block)block), meta, block.getRegistryName(), variant);
        }
    }

    public static void registerItemModel(Item item, int meta, String variant) {
        if (item != null) {
            ClientProxy.registerItemModel(item, meta, item.getRegistryName(), variant);
        }
    }

    public static void registerItemModel(Block block, int meta, ResourceLocation location) {
        if (block != null) {
            ClientProxy.registerItemModel(Item.func_150898_a((Block)block), meta, location);
        }
    }

    public static void registerItemModel(Item item, int meta, ResourceLocation location) {
        if (item != null) {
            ClientProxy.registerItemModel(item, meta, location, VARIANT_INVENTORY);
        }
    }

    public static void registerItemModel(Block block, int meta, ResourceLocation location, String variant) {
        if (block != null && !StringUtils.func_151246_b((String)variant)) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation(location, variant));
        }
    }

    public static void registerItemModel(Item item, int meta, ResourceLocation location, String variant) {
        if (item != null && !StringUtils.func_151246_b((String)variant)) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(location, variant));
        }
    }

    public static void registerItemBlockMeta(Block block) {
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            ((ItemBlockMeta)item).registerItemModels();
        }
    }

    public static void registerItemMetaDynamic(ItemMetaDynamic item) {
        if (item != null) {
            item.registerItemModels();
        }
    }

    public static void registerItemMetaDynamic(ItemEdible item) {
        if (item != null) {
            item.registerItemModels();
        }
    }

    public static void registerFluidModels(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        Block block = fluid.getBlock();
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            FluidStateMapper mapper = new FluidStateMapper(fluid);
            if (item != Items.field_190931_a) {
                ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
            }
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }

    public static void registerFluidTexture(TextureMap map, Fluid fluid) {
        if (fluid != null) {
            map.func_174942_a(fluid.getFlowing());
            map.func_174942_a(fluid.getStill());
        }
    }

    protected static void setModelStateMapper(Block block, IStateMapper mapper) {
        if (block != null) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }

    protected static void registerBlockColors(BlockColors blockColors, IBlockColor handler, Block ... blocks) {
        for (Block block : blocks) {
            if (block == null) continue;
            blockColors.func_186722_a(handler, new Block[]{block});
        }
    }

    protected static void registerItemColors(ItemColors itemColors, IItemColor handler, Block ... blocks) {
        for (Block block : blocks) {
            Item item;
            if (block == null || (item = Item.func_150898_a((Block)block)) == Items.field_190931_a) continue;
            itemColors.func_186730_a(handler, new Item[]{item});
        }
    }

    protected static void registerItemColors(ItemColors itemColors, IItemColor handler, Item ... items) {
        for (Item item : items) {
            if (item == null) continue;
            itemColors.func_186730_a(handler, new Item[]{item});
        }
    }

    protected static void replaceTexturedModel(ModelBakeEvent event, ModelResourceLocation location, String key, boolean item) {
        IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)location, (String)("Error loading model for " + location));
        IBakedModel standard = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
        TextureModel finalModel = new TextureModel(standard, model, DefaultVertexFormats.field_176600_a, key, item);
        event.getModelRegistry().func_82595_a((Object)location, (Object)finalModel);
    }

    private static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.location = new ModelResourceLocation(Util.getResource("fluid_block"), fluid.getName());
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return this.location;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return this.location;
        }
    }
}

