/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.util;

import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RecipeUtil {
    private static final Logger log = LogManager.getLogger((String)"inspirations-lib");

    private RecipeUtil() {
    }

    public static boolean isValidItemStack(String string, boolean allowWildcard) {
        String metaString = allowWildcard ? "(-1|[0-9]+)" : "[0-9]+";
        return string.matches("^[a-z0-9_.-]+:[a-z0-9_.-]+(:" + metaString + ")?$");
    }

    public static ItemStack getItemStackFromString(String string, boolean allowWildcard) {
        int meta;
        if (!RecipeUtil.isValidItemStack(string, allowWildcard)) {
            log.warn("Invalid stack string {}", (Object)string);
            return ItemStack.field_190927_a;
        }
        String[] parts = string.split(":");
        Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(parts[0], parts[1]));
        if (item == null || item == Items.field_190931_a) {
            log.debug("Failed to find stack {}", (Object)string);
            return ItemStack.field_190927_a;
        }
        int n = meta = allowWildcard ? -1 : 0;
        if (parts.length > 2) {
            meta = Integer.parseInt(parts[2]);
        }
        if (meta == -1) {
            meta = Short.MAX_VALUE;
        }
        return new ItemStack(item, 1, meta);
    }

    public static void forStackInString(String string, Consumer<ItemStack> callback) {
        ItemStack stack = RecipeUtil.getItemStackFromString(string, true);
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77960_j() == Short.MAX_VALUE) {
            NonNullList subItems = NonNullList.func_191196_a();
            stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subItems);
            for (ItemStack subStack : subItems) {
                callback.accept(subStack);
            }
        } else {
            callback.accept(stack);
        }
    }

    private static Pair<Block, Integer> getBlockFromString(String string) {
        if (!RecipeUtil.isValidItemStack(string, false)) {
            log.warn("Invalid block string {}", (Object)string);
            return null;
        }
        String[] parts = string.split(":");
        Block block = (Block)GameRegistry.findRegistry(Block.class).getValue(new ResourceLocation(parts[0], parts[1]));
        if (block == null || block == Blocks.field_150350_a) {
            log.debug("Failed to find block {}", (Object)string);
            return null;
        }
        Integer meta = null;
        if (parts.length > 2 && (meta = Integer.valueOf(Integer.parseInt(parts[2]))) == -1) {
            meta = null;
        }
        return Pair.of((Object)block, meta);
    }

    public static IBlockState getBlockStateFromString(String string) {
        Pair<Block, Integer> pair = RecipeUtil.getBlockFromString(string);
        if (pair == null) {
            return null;
        }
        if (pair.getRight() == null) {
            return ((Block)pair.getLeft()).func_176223_P();
        }
        return ((Block)pair.getLeft()).func_176203_a(((Integer)pair.getRight()).intValue());
    }

    public static void forBlockInString(String string, Consumer<IBlockState> stateConsumer, Consumer<Block> blockConsumer) {
        Pair<Block, Integer> pair = RecipeUtil.getBlockFromString(string);
        if (pair == null) {
            return;
        }
        if (pair.getRight() == null) {
            if (blockConsumer == null) {
                for (IBlockState state : ((Block)pair.getLeft()).func_176194_O().func_177619_a()) {
                    stateConsumer.accept(state);
                }
            } else {
                blockConsumer.accept((Block)pair.getLeft());
            }
        } else {
            stateConsumer.accept(((Block)pair.getLeft()).func_176203_a(((Integer)pair.getRight()).intValue()));
        }
    }
}

