/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks;

import com.google.common.eventbus.Subscribe;
import java.util.Iterator;
import knightminer.inspirations.common.CommonProxy;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.util.ReflectionUtil;
import knightminer.inspirations.shared.InspirationsShared;
import knightminer.inspirations.tweaks.TweaksEvents;
import knightminer.inspirations.tweaks.block.BlockBetterFlowerPot;
import knightminer.inspirations.tweaks.block.BlockCactusCrop;
import knightminer.inspirations.tweaks.block.BlockFittedCarpet;
import knightminer.inspirations.tweaks.block.BlockSugarCaneCrop;
import knightminer.inspirations.tweaks.item.ItemSeed;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="InspirationsTweaks", description="Various vanilla tweaks")
public class InspirationsTweaks
extends PulseBase {
    public static final String pulseID = "InspirationsTweaks";
    @SidedProxy(clientSide="knightminer.inspirations.tweaks.TweaksClientProxy", serverSide="knightminer.inspirations.common.CommonProxy")
    public static CommonProxy proxy;
    public static Block carpet;
    public static Block flowerPot;
    public static BlockCrops cactusCrop;
    public static BlockCrops sugarCaneCrop;
    public static Item potatoSeeds;
    public static Item carrotSeeds;
    public static Item sugarCaneSeeds;
    public static Item cactusSeeds;
    public static PotionType haste;
    public static PotionType strongHaste;
    public static PotionType fatigue;
    public static PotionType strongFatigue;
    public static PotionType hunger;
    public static PotionType strongHunger;
    public static PotionType resistance;
    public static PotionType longResistance;
    public static PotionType levitation;
    public static PotionType longLevitation;
    public static PotionType blindness;
    public static PotionType longBlindness;
    public static PotionType decay;
    public static PotionType strongDecay;
    public static PotionType longHunger;
    private static final ResourceLocation SILVERFISH_TABLE;
    private static final ResourceLocation CAVE_SPIDER_TABLE;
    private static final ResourceLocation SKELETON_TABLE;
    private static final IBehaviorDispenseItem DEFAULT;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        if (Config.enableFittedCarpets) {
            carpet = (Block)InspirationsTweaks.register(r, new BlockFittedCarpet(), new ResourceLocation("carpet"));
        }
        if (Config.betterFlowerPot) {
            flowerPot = (Block)InspirationsTweaks.register(r, new BlockBetterFlowerPot(), new ResourceLocation("flower_pot"));
        }
        if (Config.enableMoreSeeds) {
            cactusCrop = InspirationsTweaks.register(r, new BlockCactusCrop(), "cactus_crop");
            sugarCaneCrop = InspirationsTweaks.register(r, new BlockSugarCaneCrop(), "sugar_cane_crop");
        }
    }

    @SubscribeEvent
    public void registerItem(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        if (Config.enableMoreSeeds) {
            cactusSeeds = InspirationsTweaks.registerItem((IForgeRegistry<Item>)r, new ItemSeed(cactusCrop, EnumPlantType.Desert), "cactus_seeds");
            sugarCaneSeeds = InspirationsTweaks.registerItem((IForgeRegistry<Item>)r, new ItemSeed(sugarCaneCrop, EnumPlantType.Beach), "sugar_cane_seeds");
            carrotSeeds = InspirationsTweaks.registerItem((IForgeRegistry<Item>)r, new ItemSeeds(Blocks.field_150459_bM, Blocks.field_150458_ak), "carrot_seeds");
            potatoSeeds = InspirationsTweaks.registerItem((IForgeRegistry<Item>)r, new ItemSeeds(Blocks.field_150469_bN, Blocks.field_150458_ak), "potato_seeds");
        }
    }

    @SubscribeEvent
    public void registerPotionTypes(RegistryEvent.Register<PotionType> event) {
        IForgeRegistry r = event.getRegistry();
        if (Config.brewMissingPotions) {
            haste = InspirationsTweaks.register(r, new PotionType(new PotionEffect[]{new PotionEffect(MobEffects.field_76422_e, 3600)}), "haste");
            strongHaste = InspirationsTweaks.register(r, new PotionType("haste", new PotionEffect[]{new PotionEffect(MobEffects.field_76422_e, 1800, 1)}), "strong_haste");
            fatigue = InspirationsTweaks.register(r, new PotionType(new PotionEffect[]{new PotionEffect(MobEffects.field_76419_f, 1200)}), "fatigue");
            strongFatigue = InspirationsTweaks.register(r, new PotionType("fatigue", new PotionEffect[]{new PotionEffect(MobEffects.field_76419_f, 600, 1)}), "strong_fatigue");
            hunger = InspirationsTweaks.register(r, new PotionType(new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 900)}), "hunger");
            longHunger = InspirationsTweaks.register(r, new PotionType("hunger", new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 1800)}), "long_hunger");
            strongHunger = InspirationsTweaks.register(r, new PotionType("hunger", new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 450, 1)}), "strong_hunger");
            resistance = InspirationsTweaks.register(r, new PotionType(new PotionEffect[]{new PotionEffect(MobEffects.field_76429_m, 2400)}), "resistance");
            longResistance = InspirationsTweaks.register(r, new PotionType("resistance", new PotionEffect[]{new PotionEffect(MobEffects.field_76429_m, 6000)}), "long_resistance");
            levitation = InspirationsTweaks.register(r, new PotionType(new PotionEffect[]{new PotionEffect(MobEffects.field_188424_y, 160)}), "levitation");
            longLevitation = InspirationsTweaks.register(r, new PotionType("levitation", new PotionEffect[]{new PotionEffect(MobEffects.field_188424_y, 300)}), "long_levitation");
            blindness = InspirationsTweaks.register(r, new PotionType(new PotionEffect[]{new PotionEffect(MobEffects.field_76440_q, 600)}), "blindness");
            longBlindness = InspirationsTweaks.register(r, new PotionType("blindness", new PotionEffect[]{new PotionEffect(MobEffects.field_76440_q, 1200)}), "long_blindness");
            decay = InspirationsTweaks.register(r, new PotionType(new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 600)}), "decay");
            strongDecay = InspirationsTweaks.register(r, new PotionType("decay", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 300, 1)}), "long_decay");
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
        if (Config.addGrassDrops) {
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack(carrotSeeds), (int)4);
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack(potatoSeeds), (int)3);
        }
        if (Config.brewHeartbeet) {
            Ingredient heartbeet = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{InspirationsShared.heartbeet});
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)heartbeet, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)heartbeet, (PotionType)PotionTypes.field_185220_C);
        }
        if (Config.betterFlowerPot) {
            InspirationsRegistry.registerFlower((Block)Blocks.field_150434_aF, 0, 15);
            InspirationsRegistry.registerFlower((Block)Blocks.field_150329_H, BlockTallGrass.EnumType.FERN.func_177044_a(), 4);
        }
        if (Config.brewMissingPotions) {
            Iterator iterator = PotionHelper.field_185213_a.iterator();
            while (iterator.hasNext()) {
                PotionType input = ReflectionUtil.getMixPredicateInput(iterator.next());
                if (input != PotionTypes.field_185238_j && input != PotionTypes.field_185239_k) continue;
                iterator.remove();
            }
            Ingredient redstone = Ingredient.func_193367_a((Item)Items.field_151137_ax);
            Ingredient glowstone = Ingredient.func_193367_a((Item)Items.field_151114_aO);
            Ingredient spiderEye = Ingredient.func_193367_a((Item)Items.field_151071_bq);
            Ingredient silverfishPowder = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{InspirationsShared.silverfishPowder});
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)silverfishPowder, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)silverfishPowder, (PotionType)haste);
            PotionHelper.func_193356_a((PotionType)haste, (Ingredient)glowstone, (PotionType)strongHaste);
            PotionHelper.func_193356_a((PotionType)haste, (Ingredient)spiderEye, (PotionType)fatigue);
            PotionHelper.func_193356_a((PotionType)strongHaste, (Ingredient)spiderEye, (PotionType)strongFatigue);
            PotionHelper.func_193356_a((PotionType)fatigue, (Ingredient)glowstone, (PotionType)strongFatigue);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185220_C, (Ingredient)spiderEye, (PotionType)hunger);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185221_D, (Ingredient)spiderEye, (PotionType)longHunger);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185222_E, (Ingredient)spiderEye, (PotionType)strongHunger);
            PotionHelper.func_193356_a((PotionType)hunger, (Ingredient)redstone, (PotionType)longHunger);
            PotionHelper.func_193356_a((PotionType)hunger, (Ingredient)glowstone, (PotionType)strongHunger);
            Ingredient skulkerShell = Ingredient.func_193367_a((Item)Items.field_190930_cZ);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)skulkerShell, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)skulkerShell, (PotionType)resistance);
            PotionHelper.func_193356_a((PotionType)resistance, (Ingredient)redstone, (PotionType)longResistance);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185238_j, (Ingredient)spiderEye, (PotionType)levitation);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185239_k, (Ingredient)spiderEye, (PotionType)longLevitation);
            PotionHelper.func_193356_a((PotionType)levitation, (Ingredient)redstone, (PotionType)longLevitation);
            Ingredient inkSac = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLACK.func_176767_b())});
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)inkSac, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)inkSac, (PotionType)blindness);
            PotionHelper.func_193356_a((PotionType)blindness, (Ingredient)redstone, (PotionType)longBlindness);
            OreIngredient witherBone = new OreIngredient("boneWithered");
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)witherBone, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)witherBone, (PotionType)decay);
            PotionHelper.func_193356_a((PotionType)decay, (Ingredient)glowstone, (PotionType)strongDecay);
        }
        this.registerDispenserBehavior();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        MinecraftForge.EVENT_BUS.register(TweaksEvents.class);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (Config.brewMissingPotions && SILVERFISH_TABLE.equals((Object)event.getName())) {
            InspirationsTweaks.addToVanillaLoot(event, SILVERFISH_TABLE.func_110623_a());
        } else if (Config.caveSpiderDrops && CAVE_SPIDER_TABLE.equals((Object)event.getName())) {
            InspirationsTweaks.addToVanillaLoot(event, CAVE_SPIDER_TABLE.func_110623_a());
        } else if (Config.skeletonSkull && SKELETON_TABLE.equals((Object)event.getName())) {
            InspirationsTweaks.addToVanillaLoot(event, SKELETON_TABLE.func_110623_a());
        }
    }

    private void registerDispenserBehavior() {
        if (Config.dispensersPlaceAnvils) {
            InspirationsTweaks.registerDispenserBehavior(Blocks.field_150467_bQ, (source, stack) -> {
                BlockPos pos;
                EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                World world = source.func_82618_k();
                if (!Blocks.field_150467_bQ.func_176196_c(world, pos = source.func_180699_d().func_177972_a(facing))) {
                    return DEFAULT.func_82482_a(source, stack);
                }
                int meta = stack.func_77960_j();
                if (meta > 3 || meta < 0) {
                    meta = 3;
                }
                EnumFacing anvilFacing = facing.func_176740_k().func_176720_b() ? EnumFacing.NORTH : facing.func_176746_e();
                IBlockState state = Blocks.field_150467_bQ.func_176223_P().func_177226_a((IProperty)BlockAnvil.field_176505_b, (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)BlockAnvil.field_176506_a, (Comparable)anvilFacing);
                world.func_175656_a(pos, state);
                stack.func_190918_g(1);
                return stack;
            });
        }
    }

    static {
        SILVERFISH_TABLE = new ResourceLocation("entities/silverfish");
        CAVE_SPIDER_TABLE = new ResourceLocation("entities/cave_spider");
        SKELETON_TABLE = new ResourceLocation("entities/skeleton");
        DEFAULT = new BehaviorDefaultDispenseItem();
    }
}

