/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.client;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.Util;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;

public class PortalColorHandler
implements IBlockColor,
IWorldEventListener {
    private static final int DEFAULT_COLOR = 10037503;
    private static final Set<Block> BEACON_COLOR_BLACKLIST = new HashSet<Block>();
    public static final PortalColorHandler INSTANCE = new PortalColorHandler();

    private PortalColorHandler() {
    }

    public int func_186720_a(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
        if (world == null || pos == null) {
            return 10037503;
        }
        pos = pos.func_177977_b();
        while (world.func_180495_p(pos).func_177230_c() == Blocks.field_150427_aO) {
            pos = pos.func_177977_b();
        }
        return PortalColorHandler.getColorValue(world, pos.func_177977_b());
    }

    private static int getColorValue(IBlockAccess access, BlockPos pos) {
        IBlockState state = access.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150399_cn) {
            return ((EnumDyeColor)state.func_177229_b((IProperty)BlockStainedGlass.field_176547_a)).field_193351_w;
        }
        if (block == Blocks.field_150397_co) {
            return ((EnumDyeColor)state.func_177229_b((IProperty)BlockStainedGlassPane.field_176245_a)).field_193351_w;
        }
        if (!BEACON_COLOR_BLACKLIST.contains(block)) {
            World world = null;
            if (access instanceof World) {
                world = (World)access;
            } else if (access instanceof ChunkCache) {
                world = ((ChunkCache)access).field_72815_e;
            }
            if (world != null) {
                try {
                    float[] color = block.getBeaconColorMultiplier(state, world, pos, pos);
                    if (color != null && color.length == 3) {
                        return Util.getColorInteger(color);
                    }
                }
                catch (ClassCastException e) {
                    Inspirations.log.error("Error getting beacon color for block", (Throwable)e);
                    BEACON_COLOR_BLACKLIST.add(block);
                }
            }
        }
        return 10037503;
    }

    public void func_184376_a(World world, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        if (Minecraft.func_71410_x().field_71438_f.field_175008_n == null) {
            return;
        }
        if (world.func_180495_p(pos = pos.func_177981_b(2)).func_177230_c() == Blocks.field_150427_aO) {
            this.updatePortal(world, pos, flags);
        }
    }

    private void updatePortal(World world, BlockPos pos, int flags) {
        BlockPos update;
        RenderGlobal render = Minecraft.func_71410_x().field_71438_f;
        int relative = pos.func_177956_o() & 0xF;
        if (relative == 0) {
            render.func_184376_a(null, pos, null, null, flags);
        }
        if (world.func_180495_p(update = pos.func_177981_b(16 - relative)).func_177230_c() == Blocks.field_150427_aO) {
            render.func_184376_a(null, update, null, null, flags);
            if (relative >= 12 && world.func_180495_p(update = update.func_177981_b(16)).func_177230_c() == Blocks.field_150427_aO) {
                render.func_184376_a(null, update, null, null, flags);
            }
        }
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_190570_a(int id, boolean ignoreRange, boolean b, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
    }
}

