/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility;

import com.google.common.eventbus.Subscribe;
import knightminer.inspirations.common.CommonProxy;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.utility.UtilityEvents;
import knightminer.inspirations.utility.block.BlockBricksButton;
import knightminer.inspirations.utility.block.BlockCarpetedPressurePlate;
import knightminer.inspirations.utility.block.BlockCarpetedTrapdoor;
import knightminer.inspirations.utility.block.BlockCollector;
import knightminer.inspirations.utility.block.BlockPipe;
import knightminer.inspirations.utility.block.BlockRedstoneBarrel;
import knightminer.inspirations.utility.block.BlockRedstoneTorchLever;
import knightminer.inspirations.utility.block.BlockTorchLever;
import knightminer.inspirations.utility.dispenser.DispenseFluidTank;
import knightminer.inspirations.utility.tileentity.TileCollector;
import knightminer.inspirations.utility.tileentity.TilePipe;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="InspirationsUtility", description="Adds various utilities")
public class InspirationsUtility
extends PulseBase {
    public static final String pulseID = "InspirationsUtility";
    @SidedProxy(clientSide="knightminer.inspirations.utility.UtilityClientProxy", serverSide="knightminer.inspirations.common.CommonProxy")
    public static CommonProxy proxy;
    public static Block torchLever;
    public static Block redstoneBarrel;
    public static BlockBricksButton bricksButton;
    public static Block redstoneTorchLever;
    public static Block redstoneTorchLeverPowered;
    public static Block[] carpetedTrapdoors;
    public static Block carpetedPressurePlate1;
    public static Block carpetedPressurePlate2;
    public static Block collector;
    public static Block pipe;
    public static Item pipeItem;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        if (Config.enableTorchLever) {
            torchLever = InspirationsUtility.registerBlock((IForgeRegistry<Block>)r, new BlockTorchLever(), "torch_lever");
        }
        if (Config.enableBricksButton) {
            bricksButton = InspirationsUtility.registerBlock((IForgeRegistry<Block>)r, new BlockBricksButton(), "bricks_button");
        }
        if (Config.enableRedstoneBarrel) {
            redstoneBarrel = InspirationsUtility.registerBlock((IForgeRegistry<Block>)r, new BlockRedstoneBarrel(), "redstone_barrel");
        }
        if (Config.enableRedstoneTorchLever) {
            redstoneTorchLever = InspirationsUtility.registerBlock((IForgeRegistry<Block>)r, new BlockRedstoneTorchLever(false), "redstone_torch_lever");
            redstoneTorchLeverPowered = InspirationsUtility.registerBlock((IForgeRegistry<Block>)r, new BlockRedstoneTorchLever(true), "redstone_torch_lever_powered");
        }
        if (Config.enableCarpetedTrapdoor) {
            carpetedTrapdoors = new Block[16];
            for (EnumDyeColor color : EnumDyeColor.values()) {
                InspirationsUtility.carpetedTrapdoors[color.func_176765_a()] = InspirationsUtility.registerBlock((IForgeRegistry<Block>)r, new BlockCarpetedTrapdoor(), "carpeted_trapdoor_" + color.func_176610_l());
            }
        }
        if (Config.enableCarpetedPressurePlate) {
            carpetedPressurePlate1 = InspirationsUtility.registerBlock((IForgeRegistry<Block>)r, new BlockCarpetedPressurePlate(false), "carpeted_pressure_plate_1");
            carpetedPressurePlate2 = InspirationsUtility.registerBlock((IForgeRegistry<Block>)r, new BlockCarpetedPressurePlate.BlockCarpetedPressurePlate2(), "carpeted_pressure_plate_2");
        }
        if (Config.enableCollector) {
            collector = InspirationsUtility.registerBlock((IForgeRegistry<Block>)r, new BlockCollector(), "collector");
            InspirationsUtility.registerTE(TileCollector.class, "collector");
        }
        if (Config.enablePipe) {
            pipe = InspirationsUtility.registerBlock((IForgeRegistry<Block>)r, new BlockPipe(), "pipe");
            InspirationsUtility.registerTE(TilePipe.class, "pipe");
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        if (torchLever != null) {
            InspirationsUtility.registerItemBlock((IForgeRegistry<Item>)r, torchLever);
        }
        if (bricksButton != null) {
            InspirationsUtility.registerEnumItemBlock((IForgeRegistry<Item>)r, bricksButton);
        }
        if (redstoneBarrel != null) {
            InspirationsUtility.registerItemBlock((IForgeRegistry<Item>)r, redstoneBarrel);
        }
        if (redstoneTorchLever != null) {
            InspirationsUtility.registerItemBlock((IForgeRegistry<Item>)r, redstoneTorchLever);
        }
        if (carpetedTrapdoors != null) {
            for (Block trapdoor : carpetedTrapdoors) {
                InspirationsUtility.registerItemBlock((IForgeRegistry<Item>)r, trapdoor);
            }
        }
        if (collector != null) {
            InspirationsUtility.registerItemBlock((IForgeRegistry<Item>)r, collector);
        }
        if (pipe != null) {
            pipeItem = InspirationsUtility.registerItemBlock((IForgeRegistry<Item>)r, pipe);
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
        this.registerDispenserBehavior();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        MinecraftForge.EVENT_BUS.register(UtilityEvents.class);
    }

    private void registerDispenserBehavior() {
        if (Config.enableDispenserFluidTanks) {
            for (String container : Config.fluidContainers) {
                Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(container));
                if (item == null || item == Items.field_190931_a) continue;
                InspirationsUtility.registerDispenseTankLogic(item);
            }
        }
    }

    private static void registerDispenseTankLogic(Item item) {
        InspirationsUtility.registerDispenserBehavior(item, (IBehaviorDispenseItem)new DispenseFluidTank((IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)item)));
    }
}

