/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskyui;

import com.codehusky.huskyui.StateContainer;
import com.codehusky.huskyui.states.element.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;

public class ElementRegistry
extends StateContainer {
    private HashMap<Integer, Element> elements = new HashMap();
    private HashMap<Integer, Integer> autoInvLocations = new HashMap();
    private ArrayList<Integer> autoInvElements = new ArrayList();
    private int elementIncrement = 0;

    ElementRegistry() {
    }

    public int registerElement(Element element) {
        int key = this.elementIncrement++;
        this.elements.put(key, element);
        return key;
    }

    public void unregisterElement(int id) {
        if (this.elements.containsKey(id)) {
            this.elements.remove(id);
            if (this.autoInvElements.contains(id)) {
                this.autoInvElements.remove(id);
                if (this.autoInvLocations.values().contains(id)) {
                    this.autoInvLocations.values().removeIf(val -> id == val);
                }
            }
        } else {
            throw new RuntimeException("Cannot unregister element: Element id \"" + id + "\" is not registered.");
        }
    }

    public int registerAutoElement(Element element) {
        int id = this.registerElement(element);
        this.autoInvElements.add(id);
        return id;
    }

    public void registerAutoElement(int elementID) {
        if (!this.elements.containsKey(elementID)) {
            throw new RuntimeException("Cannot register element as auto: Element id \"" + elementID + "\" is not registered.");
        }
        if (this.autoInvElements.contains(elementID)) {
            return;
        }
        this.autoInvElements.add(elementID);
    }

    public int registerAutoElement(int slotID, Element element) {
        int id = this.registerElement(element);
        this.autoInvLocations.put(slotID, id);
        this.autoInvElements.add(id);
        return id;
    }

    public void registerAutoElement(int slotID, int elementID) {
        if (!this.elements.containsKey(elementID)) {
            throw new RuntimeException("Cannot register element as auto: Element id \"" + elementID + "\" is not registered.");
        }
        this.autoInvLocations.put(slotID, elementID);
        if (!this.autoInvElements.contains(elementID)) {
            this.autoInvElements.add(elementID);
        }
    }

    public HashMap<Integer, ItemStack> getAutoItems() {
        HashMap<Integer, ItemStack> stacks = new HashMap<Integer, ItemStack>();
        for (int i : this.autoInvElements) {
            stacks.put(i, this.getItemStackForElement(i));
        }
        return stacks;
    }

    public HashMap<Integer, Integer> getAutoItemLocations() {
        return this.autoInvLocations;
    }

    public Optional<Element> getElementFromItemStack(ItemStack stack) {
        Optional<Integer> optID = this.getElementIDFromItemStack(stack);
        if (optID.isPresent() && this.elements.containsKey(optID.get())) {
            return Optional.of(this.elements.get(optID.get()));
        }
        return Optional.empty();
    }

    public Optional<Integer> getElementIDFromItemStack(ItemStack stack) {
        if (stack.getType() == ItemTypes.AIR || stack.getType() == ItemTypes.NONE) {
            return Optional.empty();
        }
        Optional optRegID = stack.toContainer().get(DataQuery.of((String[])new String[]{"UnsafeData", "regid"}));
        if (optRegID.isPresent()) {
            return Optional.of(Integer.valueOf((Integer)optRegID.get()));
        }
        return Optional.empty();
    }

    public boolean elementExists(int id) {
        return this.elements.containsKey(id);
    }

    public boolean isElementAuto(int id) {
        if (!this.elements.containsKey(id)) {
            throw new RuntimeException("Cannot check if element is auto: Element id \"" + id + "\" is not registered.");
        }
        return this.autoInvElements.contains(id);
    }

    public boolean isElementFixedAuto(int id) {
        if (!this.isElementAuto(id)) {
            throw new RuntimeException("Cannot check if element is fixed auto: Element \"" + id + "\"is not auto.");
        }
        return this.autoInvLocations.values().contains(id);
    }

    public ItemStack getItemStackForElement(int elementID) {
        if (this.elements.containsKey(elementID)) {
            return ItemStack.builder().fromContainer((DataView)this.elements.get(elementID).getItem().toContainer().set(DataQuery.of((String[])new String[]{"UnsafeData", "regid"}), (Object)elementID)).build();
        }
        throw new RuntimeException("Cannot get ItemStack: Element id \"" + elementID + "\" is not registered.");
    }
}

