/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskyui;

import com.codehusky.huskyui.ElementRegistry;
import com.codehusky.huskyui.states.element.ActionableElement;
import com.codehusky.huskyui.states.element.Element;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.event.item.inventory.UseItemStackEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;

@Plugin(id="huskyui", name="HuskyUI", version="0.6.0PRE4", description="A framework for Inventory UI.")
public class HuskyUI {
    public static final String PLUGIN_ID = "huskyui";
    public static final String PLUGIN_NAME = "HuskyUI";
    public static final String PLUGIN_VERSION = "0.6.0PRE4";
    private static final Logger LOGGER = LoggerFactory.getLogger(HuskyUI.class);
    private final ElementRegistry registry = new ElementRegistry();
    private static HuskyUI instance;
    @Nonnull
    private final PluginContainer pluginContainer;
    private Cause genericCause;

    @Inject
    public HuskyUI(@Nonnull PluginContainer pluginContainer) {
        instance = this;
        this.pluginContainer = pluginContainer;
    }

    public static HuskyUI getInstance() {
        return instance;
    }

    @Nonnull
    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public ElementRegistry getElementRegistry() {
        return this.registry;
    }

    @Listener
    public void onPlayerSpawn(ClientConnectionEvent.Join event) {
        HashMap<Integer, ItemStack> items = this.registry.getAutoItems();
        HashMap<Integer, Integer> itemPositions = this.registry.getAutoItemLocations();
        if (itemPositions.size() > 0) {
            event.getTargetEntity().getInventory().clear();
            int slotNum = 0;
            for (Inventory slot : event.getTargetEntity().getInventory().slots()) {
                if (itemPositions.containsKey(slotNum)) {
                    slot.set(items.get(itemPositions.get(slotNum)));
                }
                ++slotNum;
            }
            Iterator<Object> iterator = items.keySet().iterator();
            while (iterator.hasNext()) {
                int elementID = (Integer)iterator.next();
                if (itemPositions.containsValue(elementID)) continue;
                event.getTargetEntity().getInventory().offer(items.get(elementID));
            }
        } else {
            int slotNum = 0;
            for (Inventory slot : event.getTargetEntity().getInventory().slots()) {
                Optional<Integer> eleID;
                if (slot.peek().isPresent() && (eleID = this.registry.getElementIDFromItemStack((ItemStack)slot.peek().get())).isPresent()) {
                    slot.clear();
                }
                ++slotNum;
            }
            Iterator<Object> iterator = items.keySet().iterator();
            while (iterator.hasNext()) {
                int elementID = (Integer)iterator.next();
                if (itemPositions.containsValue(elementID)) continue;
                event.getTargetEntity().getInventory().offer(items.get(elementID));
            }
        }
    }

    @Listener(order=Order.LAST)
    public void onElementInteract(InteractItemEvent event) {
        Optional<Element> ele = this.registry.getElementFromItemStack(event.getItemStack().createStack());
        if (ele.isPresent()) {
            if (event instanceof InteractItemEvent.Secondary && ele.get() instanceof ActionableElement) {
                ActionableElement aElement = ((ActionableElement)ele.get()).copy(this.registry);
                aElement.getAction().setObserver((Player)event.getCause().root());
                aElement.getAction().runAction("", null);
            }
            event.setCancelled(true);
        }
    }

    @Listener
    public void onItemDrop(DropItemEvent.Dispense event) {
        for (Entity e : event.getEntities()) {
            ItemStack affectedStack;
            Optional<Integer> potentialID;
            if (!(e instanceof Item) || !(potentialID = this.registry.getElementIDFromItemStack(affectedStack = ((ItemStackSnapshot)((Item)e).getItemData().item().get()).createStack())).isPresent() || !this.registry.elementExists(potentialID.get())) continue;
            event.setCancelled(true);
        }
    }

    @Listener
    public void onItemUse(UseItemStackEvent.Start event) {
        Optional<Integer> potentialID = this.registry.getElementIDFromItemStack(event.getItemStackInUse().createStack());
        if (potentialID.isPresent() && this.registry.elementExists(potentialID.get())) {
            event.setCancelled(true);
        }
    }

    @Listener(order=Order.PRE)
    public void onItemClick(ClickInventoryEvent event) {
        try {
            if (event instanceof ClickInventoryEvent.Primary || event instanceof ClickInventoryEvent.Secondary || event instanceof ClickInventoryEvent.Shift || event instanceof ClickInventoryEvent.Creative) {
                Optional<Integer> potentialID;
                ItemStack affected = ((ItemStackSnapshot)((SlotTransaction)event.getTransactions().get(0)).getOriginal()).createStack();
                if (event instanceof ClickInventoryEvent.Shift && (affected.getType() == ItemTypes.AIR || affected.getType() == ItemTypes.NONE)) {
                    affected = ((ItemStackSnapshot)((SlotTransaction)event.getTransactions().get(0)).getDefault()).createStack();
                }
                if ((potentialID = this.registry.getElementIDFromItemStack(affected)).isPresent() && this.registry.elementExists(potentialID.get()) && this.registry.isElementAuto(potentialID.get())) {
                    if (((SlotTransaction)event.getTransactions().get(0)).getSlot().parent().getArchetype().equals(InventoryArchetypes.PLAYER)) {
                        if (this.registry.isElementFixedAuto(potentialID.get())) {
                            event.setCancelled(true);
                        }
                    } else {
                        event.setCancelled(true);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

