/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskyui;

import com.codehusky.huskyui.InventoryUtil;
import com.codehusky.huskyui.states.Page;
import com.codehusky.huskyui.states.State;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class StateContainer {
    @Nonnull
    private final Map<String, State> states;
    @Nullable
    private String initialState;

    public StateContainer() {
        this(Maps.newHashMap());
    }

    public StateContainer(@Nonnull Map<String, State> states) {
        this.states = states;
        this.initialState = null;
    }

    public StateContainer(@Nonnull Map<String, State> states, @Nonnull String initialState) {
        this.states = states;
        this.initialState = initialState;
    }

    @Nonnull
    public Map<String, State> getStates() {
        return this.states;
    }

    @Nullable
    public State getState(@Nonnull String id) {
        return this.states.get(id);
    }

    public boolean hasState(@Nonnull String id) {
        return this.getState(id) != null;
    }

    public void addState(@Nonnull State state) {
        state.setContainer(this);
        if (this.states.containsKey(state.getId())) {
            throw new IllegalStateException("A State with ID \"" + state.getId() + "\" already exists in this container.");
        }
        if (this.initialState == null) {
            this.initialState = state.getId();
        }
        this.states.put(state.getId(), state);
    }

    public void removeState(@Nonnull String id) {
        if (this.initialState != null && this.initialState.equals(id)) {
            this.initialState = null;
        }
        this.states.remove(id);
    }

    public void removeState(@Nonnull State state) {
        if (this.hasState(state.getId())) {
            this.removeState(state.getId());
        }
    }

    public void setInitialState(@Nonnull State state) {
        this.initialState = state.getId();
        if (!this.states.containsKey(state.getId())) {
            this.addState(state);
        }
    }

    public void openState(@Nonnull Player player, @Nonnull String id) {
        State state;
        int pagenum = 0;
        String pageID = id;
        if (id.contains("#")) {
            try {
                pagenum = Integer.valueOf(id.split("#")[1]);
                pageID = id.split("#")[0];
            }
            catch (Exception e) {
                StateContainer.fail(player, "Attempted to open an invalid pagenum!");
            }
        }
        if ((state = this.states.get(pageID)) == null) {
            StateContainer.fail(player, "Attempted to open a nonexistent state!");
            StateContainer.fail(player, "Invalid ID: " + id);
            InventoryUtil.close(player);
            return;
        }
        state = state.copy(this);
        state.setObserver(player);
        if (state instanceof Page) {
            Page page = (Page)state;
            Inventory toShow = page.getPageView(pagenum);
            InventoryUtil.open(player, toShow);
            return;
        }
        InventoryUtil.close(player);
        StateContainer.fail(player, "Attempted to open an invalid or incomplete state!");
        StateContainer.fail(player, "Invalid ID: " + id);
    }

    public void launchFor(@Nonnull Player player) {
        if (this.initialState == null) {
            StateContainer.fail(player, "Attempted to open a container without an initial state!");
            return;
        }
        this.openState(player, this.initialState);
    }

    @Nonnull
    public StateContainer copy() {
        StateContainer container = new StateContainer();
        for (State state : this.states.values()) {
            container.addState(state.copy(container));
        }
        if (this.initialState != null) {
            container.setInitialState(this.states.get(this.initialState));
        }
        return container;
    }

    private static void fail(@Nonnull Player player, @Nonnull String message) {
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, message}));
    }
}

