/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskyui.states;

import com.codehusky.huskyui.HuskyUI;
import com.codehusky.huskyui.InventoryUtil;
import com.codehusky.huskyui.StateContainer;
import com.codehusky.huskyui.states.State;
import com.codehusky.huskyui.states.element.ActionableElement;
import com.codehusky.huskyui.states.element.Element;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.property.InventoryDimension;
import org.spongepowered.api.item.inventory.property.InventoryTitle;
import org.spongepowered.api.item.inventory.property.StringProperty;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;

public class Page
extends State {
    @Nonnull
    public static ItemStack defaultEmptyStack = ItemStack.builder().itemType(ItemTypes.STAINED_GLASS_PANE).add(Keys.DYE_COLOR, (Object)DyeColors.BLACK).add(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{TextColors.DARK_GRAY, "HuskyUI"})).build();
    @Nonnull
    private final Map<Integer, Element> elements;
    @Nonnull
    private final InventoryDimension inventoryDimension;
    @Nonnull
    private final InventoryArchetype inventoryArchetype;
    @Nonnull
    private final Text title;
    @Nonnull
    private final ItemStack emptyStack;
    private final boolean fillWhenEmpty;
    private final boolean autoPaging;
    private final boolean centered;
    private final int rows;
    private boolean updatable;
    private int updateTickRate;
    private Consumer<Page> updateConsumer;
    private Runnable interrupt;
    private Inventory cachedInventory;
    private Task updaterTask;
    private long ticks = 0L;

    public Page(@Nonnull String id, @Nonnull Map<Integer, Element> elements, @Nonnull InventoryDimension inventoryDimension, @Nonnull InventoryArchetype inventoryArchetype, @Nonnull Text title, @Nonnull ItemStack emptyStack, boolean updatable, int updateTickRate, Consumer<Page> updateConsumer, Runnable interrupt, boolean fillWhenEmpty, boolean autoPaging, boolean centered, int rows, String parent) {
        super(id);
        this.elements = elements;
        this.inventoryDimension = inventoryDimension;
        this.inventoryArchetype = inventoryArchetype;
        this.title = title;
        this.emptyStack = emptyStack;
        this.fillWhenEmpty = fillWhenEmpty;
        this.autoPaging = autoPaging;
        this.centered = centered;
        this.rows = rows;
        this.updatable = updatable;
        this.updateTickRate = updateTickRate;
        this.updateConsumer = updateConsumer;
        this.interrupt = interrupt;
        this.cachedInventory = null;
        this.setParent(parent);
    }

    public Consumer<Page> getUpdateConsumer() {
        return this.updateConsumer;
    }

    public int getUpdateTickRate() {
        return this.updateTickRate;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    @Nonnull
    public Map<Integer, Element> getElements() {
        return this.elements;
    }

    @Nonnull
    public InventoryDimension getInventoryDimension() {
        return this.inventoryDimension;
    }

    @Nonnull
    public Text getTitle() {
        return this.title;
    }

    @Nonnull
    public ItemStack getEmptyStack() {
        return this.emptyStack;
    }

    public boolean isFillWhenEmpty() {
        return this.fillWhenEmpty;
    }

    public boolean isAutoPaging() {
        return this.autoPaging;
    }

    public int getRows() {
        return this.rows;
    }

    public long getActualTicks() {
        return this.ticks;
    }

    public long getTicks() {
        return (long)Math.floor(this.ticks / (long)this.updateTickRate);
    }

    public void tickIncrement() {
        ++this.ticks;
    }

    @Nonnull
    public Inventory getPageView() {
        return this.getPageView(0);
    }

    @Nonnull
    public Inventory getPageView(int pagenum) {
        if (this.updatable && this.cachedInventory != null) {
            return this.cachedInventory;
        }
        int maxSize = Math.max(1, this.inventoryDimension.getColumns() * (this.inventoryDimension.getRows() - 1));
        int pageCount = this.elements.size() / maxSize + 1;
        Inventory inventory = Inventory.builder().property("type", (InventoryProperty)new StringProperty("huskui-page")).property("id", (InventoryProperty)new StringProperty(this.getId())).property("inventorydimension", (InventoryProperty)this.inventoryDimension).of(this.inventoryArchetype).listener(InteractInventoryEvent.class, event -> {
            if (event instanceof InteractInventoryEvent.Close) {
                if (this.interrupt != null) {
                    this.interrupt();
                }
                return;
            }
            if (!(event instanceof InteractInventoryEvent.Open) && !(event instanceof InteractInventoryEvent.Close)) {
                block7: {
                    event.setCancelled(true);
                    try {
                        if (((ItemStackSnapshot)event.getCursorTransaction().getDefault()).getType() == ItemTypes.AIR) {
                            return;
                        }
                    }
                    catch (NoSuchFieldError err) {
                        if (((ItemStackSnapshot)event.getCursorTransaction().getDefault()).getType() != ItemTypes.NONE) break block7;
                        return;
                    }
                }
                ((ItemStackSnapshot)event.getCursorTransaction().getDefault()).toContainer().get(DataQuery.of((String[])new String[]{"UnsafeData", "slotnum"})).ifPresent(slot -> {
                    int num = (Integer)slot;
                    if (this.autoPaging) {
                        if (num == -1) {
                            if (this.hasParent()) {
                                this.getContainer().openState(this.getObserver(), this.getParent());
                            } else {
                                InventoryUtil.close(this.getObserver());
                            }
                        } else if (num == -2) {
                            this.getContainer().openState(this.getObserver(), this.getId() + "#" + (pagenum - 1));
                        } else if (num == -3) {
                            this.getContainer().openState(this.getObserver(), this.getId() + "#" + (pagenum + 1));
                        } else if (this.elements.get(num) instanceof ActionableElement) {
                            ((ActionableElement)this.elements.get(num)).getAction().runAction(this.getId(), (Inventory)this.getObserver().getOpenInventory().get());
                        }
                    } else if (this.elements.get(num) instanceof ActionableElement) {
                        ((ActionableElement)this.elements.get(num)).getAction().runAction(this.getId(), (Inventory)this.getObserver().getOpenInventory().get());
                    }
                });
            } else {
                event.getCursorTransaction().setCustom((DataSerializable)ItemStackSnapshot.NONE);
                event.getCursorTransaction().setValid(true);
            }
        }).property("inventorytitle", (InventoryProperty)InventoryTitle.of((Text)this.title)).build((Object)HuskyUI.getInstance());
        int num = 0;
        for (Inventory slot : inventory.slots()) {
            if (this.autoPaging) {
                if (num == this.rows * 9 && pageCount > 1 && pagenum > 0) {
                    slot.set(ItemStack.builder().fromContainer((DataView)ItemStack.builder().itemType(ItemTypes.MAP).add(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{TextStyles.RESET, TextColors.WHITE, "Previous"})).build().toContainer().set(DataQuery.of((String[])new String[]{"UnsafeData", "slotnum"}), (Object)-2)).build());
                } else if (num == this.rows * 9 + 8 && pageCount > 1 && pagenum < pageCount - 1) {
                    slot.set(ItemStack.builder().fromContainer((DataView)ItemStack.builder().itemType(ItemTypes.MAP).add(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{TextStyles.RESET, TextColors.WHITE, "Next"})).build().toContainer().set(DataQuery.of((String[])new String[]{"UnsafeData", "slotnum"}), (Object)-3)).build());
                } else if (num == this.rows * 9 + 4) {
                    slot.set(ItemStack.builder().fromContainer((DataView)ItemStack.builder().itemType(ItemTypes.BARRIER).add(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{TextStyles.RESET, TextColors.WHITE, this.hasParent() ? "Back" : "Close"})).build().toContainer().set(DataQuery.of((String[])new String[]{"UnsafeData", "slotnum"}), (Object)-1)).build());
                } else if (num > this.rows * 9 - 1) {
                    slot.set(this.emptyStack);
                } else if (this.elements.containsKey(num + pagenum * maxSize)) {
                    slot.set(ItemStack.builder().fromContainer((DataView)this.elements.get(num + pagenum * maxSize).getItem().toContainer().set(DataQuery.of((String[])new String[]{"UnsafeData", "slotnum"}), (Object)(num + pagenum * maxSize))).build());
                }
            } else if (this.elements.containsKey(num)) {
                slot.set(ItemStack.builder().fromContainer((DataView)this.elements.get(num).getItem().toContainer().set(DataQuery.of((String[])new String[]{"UnsafeData", "slotnum"}), (Object)num)).build());
            }
            ++num;
        }
        if (this.updatable) {
            this.cachedInventory = inventory;
            this.updaterTask = Task.builder().intervalTicks(1L).execute(() -> {
                if (this.getActualTicks() % (long)this.getUpdateTickRate() == 0L) {
                    this.updateConsumer.accept(this);
                }
                this.tickIncrement();
            }).submit((Object)HuskyUI.getInstance());
        }
        return inventory;
    }

    @Override
    public void setObserver(Player observer) {
        if (observer == null) {
            return;
        }
        super.setObserver(observer);
        for (Element e : this.elements.values()) {
            if (!(e instanceof ActionableElement)) continue;
            ((ActionableElement)e).getAction().setObserver(observer);
        }
    }

    public void interrupt() {
        if (this.hasInterupt()) {
            try {
                this.interrupt.run();
                this.interrupt = null;
                System.out.println("Interrupt ran.");
            }
            catch (Exception e) {
                HuskyUI.getLogger().error("Error occurred while running HuskyUI Page interrupt.");
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("Interrupt either doen't exist, or has been called already");
        }
        if (this.updaterTask != null) {
            this.updaterTask.cancel();
            System.out.println("Updater cancelled");
            this.updaterTask = null;
            System.out.println("Updater set to null.");
        }
        if (this.hasObserver()) {
            this.getObserver().closeInventory();
        }
    }

    public boolean hasInterupt() {
        return this.interrupt != null;
    }

    @Override
    @Nonnull
    public Page copy(@Nonnull StateContainer newContainer) {
        PageBuilder builder = Page.builder();
        for (Map.Entry<Integer, Element> entry : this.elements.entrySet()) {
            builder.putElement(entry.getKey(), entry.getValue().copy(newContainer));
        }
        builder.setInventoryDimension(this.inventoryDimension);
        builder.setInventoryArchetype(this.inventoryArchetype);
        builder.setTitle(this.title);
        builder.setEmptyStack(this.emptyStack.copy());
        builder.setFillWhenEmpty(this.fillWhenEmpty);
        builder.setAutoPaging(this.autoPaging);
        builder.setCentered(this.centered);
        builder.setUpdateTickRate(this.updateTickRate);
        builder.setUpdater(this.updateConsumer);
        builder.setInterrupt(this.interrupt);
        builder.setUpdatable(this.updatable);
        Page page = builder.build(this.getId());
        page.setContainer(newContainer);
        page.setObserver(this.getObserver());
        page.setParent(this.getParent());
        return page;
    }

    public static PageBuilder builder() {
        return new PageBuilder();
    }

    public static class PageBuilder {
        @Nonnull
        private final Map<Integer, Element> elements = Maps.newHashMap();
        private InventoryDimension inventoryDimension = null;
        private InventoryArchetype inventoryArchetype;
        private Text title = Text.of((String)"Unnamed Page");
        private ItemStack emptyStack = defaultEmptyStack;
        private boolean fillWhenEmpty = false;
        private boolean autoPaging = false;
        private boolean centered = true;
        private boolean updatable = false;
        private int updateTickRate = 1;
        private Consumer<Page> updaterConsumer = null;
        private Runnable interrupt = null;
        @Nullable
        private String parent = null;

        private PageBuilder() {
            this.inventoryArchetype = InventoryArchetypes.CHEST;
        }

        public PageBuilder putElement(int slot, @Nonnull Element element) {
            this.elements.put(slot, element);
            return this;
        }

        public PageBuilder addElement(@Nonnull Element element) {
            this.elements.put(this.elements.size(), element);
            return this;
        }

        @Nonnull
        public PageBuilder setInventoryDimension(@Nonnull InventoryDimension inventoryDimension) {
            this.inventoryDimension = inventoryDimension;
            return this;
        }

        @Nonnull
        public PageBuilder setInventoryArchetype(@Nonnull InventoryArchetype inventoryArchetype) {
            this.inventoryArchetype = inventoryArchetype;
            return this;
        }

        @Nonnull
        public PageBuilder setTitle(@Nonnull Text title) {
            this.title = title;
            return this;
        }

        public PageBuilder setParent(@Nullable String parent) {
            this.parent = parent;
            return this;
        }

        @Nonnull
        public PageBuilder setEmptyStack(@Nonnull ItemStack emptyStack) {
            this.emptyStack = emptyStack;
            return this;
        }

        @Nonnull
        public PageBuilder setFillWhenEmpty(boolean fillWhenEmpty) {
            this.fillWhenEmpty = fillWhenEmpty;
            return this;
        }

        @Nonnull
        public PageBuilder setAutoPaging(boolean autoPaging) {
            this.autoPaging = autoPaging;
            return this;
        }

        @Nonnull
        public PageBuilder setCentered(boolean centered) {
            this.centered = centered;
            return this;
        }

        @Nonnull
        public PageBuilder setUpdatable(boolean updatable) {
            this.updatable = updatable;
            return this;
        }

        @Nonnull
        public PageBuilder setUpdateTickRate(int updateTickRate) {
            this.updateTickRate = updateTickRate;
            return this;
        }

        @Nonnull
        public PageBuilder setUpdater(Consumer<Page> updaterConsumer) {
            this.updaterConsumer = updaterConsumer;
            return this;
        }

        @Nonnull
        public PageBuilder setInterrupt(Runnable interrupt) {
            this.interrupt = interrupt;
            return this;
        }

        public Page build(@Nonnull String id) {
            int rows;
            int n = rows = this.inventoryDimension == null ? Math.min(5, (int)Math.ceil((double)this.elements.size() / 9.0)) : this.inventoryDimension.getRows() - 1;
            InventoryDimension real = this.inventoryDimension == null ? (this.autoPaging ? InventoryDimension.of((int)9, (int)(rows + 1)) : InventoryDimension.of((int)9, (int)4)) : this.inventoryDimension;
            return new Page(id, this.elements, real, this.inventoryArchetype, this.title, this.emptyStack, this.updatable, this.updateTickRate, this.updaterConsumer, this.interrupt, this.fillWhenEmpty, this.autoPaging, this.centered, rows, this.parent);
        }
    }
}

