/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskyui.states;

import com.codehusky.huskyui.StateContainer;
import javax.annotation.Nonnull;
import org.spongepowered.api.entity.living.player.Player;

public class State {
    private final String id;
    private String parent;
    private StateContainer container;
    private Player observer;

    public State() {
        this("null");
    }

    public State(@Nonnull String id) {
        this.id = id;
        this.parent = null;
        this.container = null;
        this.observer = null;
    }

    public String getId() {
        return this.id;
    }

    public String getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void setParent(String parent) {
        if (parent == null) {
            return;
        }
        this.parent = parent;
    }

    public StateContainer getContainer() {
        return this.container;
    }

    public void setContainer(@Nonnull StateContainer container) {
        this.container = container;
    }

    public boolean isHeadless() {
        return this.container == null;
    }

    public Player getObserver() {
        return this.observer;
    }

    public boolean hasObserver() {
        return this.observer != null;
    }

    public void setObserver(Player observer) {
        this.observer = observer;
    }

    @Nonnull
    public State copy(@Nonnull StateContainer newContainer) {
        State state = new State(this.id);
        state.setContainer(newContainer);
        state.setObserver(this.observer);
        state.setParent(this.parent);
        return state;
    }
}

