/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskyui.states.action;

import com.codehusky.huskyui.InventoryUtil;
import com.codehusky.huskyui.StateContainer;
import com.codehusky.huskyui.states.Page;
import com.codehusky.huskyui.states.action.ActionType;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class Action {
    @Nonnull
    private final StateContainer container;
    private Player observer = null;
    @Nonnull
    private final ActionType type;
    @Nonnull
    private final String goalState;

    public Action(@Nonnull StateContainer container, @Nonnull ActionType type, @Nonnull String goalState) {
        this.container = container;
        this.type = type;
        this.goalState = goalState;
    }

    @Nonnull
    public StateContainer getContainer() {
        return this.container;
    }

    public Player getObserver() {
        return this.observer;
    }

    public void setObserver(Player observer) {
        this.observer = observer;
    }

    @Nonnull
    public ActionType getType() {
        return this.type;
    }

    @Nonnull
    public String getGoalState() {
        return this.goalState;
    }

    public void runAction(@Nonnull String currentState, Inventory inventory) {
        switch (this.type) {
            case CLOSE: {
                InventoryUtil.close(this.observer);
                break;
            }
            case BACK: {
                if (!this.container.hasState(currentState)) break;
                if (this.container.getState(currentState).hasParent()) {
                    this.container.openState(this.observer, this.container.getState(currentState).getParent());
                    break;
                }
                this.observer.playSound(SoundTypes.BLOCK_ANVIL_LAND, this.observer.getLocation().getPosition(), 0.5);
                InventoryUtil.close(this.observer);
                this.observer.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Impossible BACK action - closing broken State."}));
                break;
            }
            case NORMAL: {
                this.container.openState(this.observer, this.goalState);
                break;
            }
            case NONE: {
                break;
            }
            case REFRESH: {
                Page page = (Page)this.getContainer().getState(currentState);
                try {
                    Consumer<Page> goo = page.getUpdateConsumer();
                    if (goo == null) break;
                    goo.accept(page);
                }
                catch (Exception e) {
                    this.observer.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Impossible refresh action - closing broken State."}));
                }
                break;
            }
            default: {
                this.observer.sendMessage((Text)Text.of((String)"??"));
            }
        }
    }

    @Nonnull
    public Action copy(@Nonnull StateContainer newContainer) {
        return new Action(newContainer, this.type, this.goalState);
    }
}

